/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.state.CompositeStateHandle;
import org.apache.flink.runtime.state.PlaceholderStreamStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistryFactory;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedStateRegistry
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SharedStateRegistry.class);
    public static final SharedStateRegistryFactory DEFAULT_FACTORY = SharedStateRegistry::new;
    private final Map<SharedStateRegistryKey, SharedStateEntry> registeredStates = new HashMap<SharedStateRegistryKey, SharedStateEntry>();
    private boolean open;
    private final Executor asyncDisposalExecutor;

    public SharedStateRegistry() {
        this(Executors.directExecutor());
    }

    public SharedStateRegistry(Executor asyncDisposalExecutor) {
        this.asyncDisposalExecutor = (Executor)Preconditions.checkNotNull((Object)asyncDisposalExecutor);
        this.open = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result registerReference(SharedStateRegistryKey registrationKey, StreamStateHandle state) {
        SharedStateEntry entry;
        Preconditions.checkNotNull((Object)state);
        StreamStateHandle scheduledStateDeletion = null;
        Map<SharedStateRegistryKey, SharedStateEntry> map = this.registeredStates;
        synchronized (map) {
            Preconditions.checkState((boolean)this.open, (Object)"Attempt to register state to closed SharedStateRegistry.");
            entry = this.registeredStates.get((Object)registrationKey);
            if (entry == null) {
                Preconditions.checkState((!this.isPlaceholder(state) ? 1 : 0) != 0, (Object)("Attempt to reference unknown state: " + (Object)((Object)registrationKey)));
                entry = new SharedStateEntry(state);
                this.registeredStates.put(registrationKey, entry);
            } else {
                if (!Objects.equals(state, entry.stateHandle)) {
                    scheduledStateDeletion = state;
                    LOG.trace("Identified duplicate state registration under key {}. New state {} was determined to be an unnecessary copy of existing state {} and will be dropped.", new Object[]{registrationKey, state, entry.stateHandle});
                }
                entry.increaseReferenceCount();
            }
        }
        this.scheduleAsyncDelete(scheduledStateDeletion);
        LOG.trace("Registered shared state {} under key {}.", (Object)entry, (Object)registrationKey);
        return new Result(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result unregisterReference(SharedStateRegistryKey registrationKey) {
        Result result;
        StreamStateHandle scheduledStateDeletion;
        SharedStateEntry entry;
        Preconditions.checkNotNull((Object)((Object)registrationKey));
        Map<SharedStateRegistryKey, SharedStateEntry> map = this.registeredStates;
        synchronized (map) {
            entry = this.registeredStates.get((Object)registrationKey);
            Preconditions.checkState((entry != null ? 1 : 0) != 0, (String)"Cannot unregister a state that is not registered: %s", (Object[])new Object[]{registrationKey});
            entry.decreaseReferenceCount();
            if (entry.getReferenceCount() <= 0) {
                this.registeredStates.remove((Object)registrationKey);
                scheduledStateDeletion = entry.getStateHandle();
                result = new Result(null, 0);
            } else {
                scheduledStateDeletion = null;
                result = new Result(entry);
            }
        }
        LOG.trace("Unregistered shared state {} under key {}.", (Object)entry, (Object)registrationKey);
        this.scheduleAsyncDelete(scheduledStateDeletion);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAll(Iterable<? extends CompositeStateHandle> stateHandles) {
        if (stateHandles == null) {
            return;
        }
        Map<SharedStateRegistryKey, SharedStateEntry> map = this.registeredStates;
        synchronized (map) {
            for (CompositeStateHandle compositeStateHandle : stateHandles) {
                compositeStateHandle.registerSharedStates(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<SharedStateRegistryKey, SharedStateEntry> map = this.registeredStates;
        synchronized (map) {
            return "SharedStateRegistry{registeredStates=" + this.registeredStates + '}';
        }
    }

    private void scheduleAsyncDelete(StreamStateHandle streamStateHandle) {
        if (streamStateHandle != null && !this.isPlaceholder(streamStateHandle)) {
            LOG.trace("Scheduled delete of state handle {}.", (Object)streamStateHandle);
            AsyncDisposalRunnable asyncDisposalRunnable = new AsyncDisposalRunnable(streamStateHandle);
            try {
                this.asyncDisposalExecutor.execute(asyncDisposalRunnable);
            }
            catch (RejectedExecutionException ex) {
                asyncDisposalRunnable.run();
            }
        }
    }

    private boolean isPlaceholder(StreamStateHandle stateHandle) {
        return stateHandle instanceof PlaceholderStreamStateHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<SharedStateRegistryKey, SharedStateEntry> map = this.registeredStates;
        synchronized (map) {
            this.open = false;
        }
    }

    private static final class AsyncDisposalRunnable
    implements Runnable {
        private final StateObject toDispose;

        public AsyncDisposalRunnable(StateObject toDispose) {
            this.toDispose = (StateObject)Preconditions.checkNotNull((Object)toDispose);
        }

        @Override
        public void run() {
            try {
                this.toDispose.discardState();
            }
            catch (Exception e) {
                LOG.warn("A problem occurred during asynchronous disposal of a shared state object: {}", (Object)this.toDispose, (Object)e);
            }
        }
    }

    public static class Result {
        private final StreamStateHandle reference;
        private final int referenceCount;

        private Result(SharedStateEntry sharedStateEntry) {
            this.reference = sharedStateEntry.getStateHandle();
            this.referenceCount = sharedStateEntry.getReferenceCount();
        }

        public Result(StreamStateHandle reference, int referenceCount) {
            Preconditions.checkArgument((referenceCount >= 0 ? 1 : 0) != 0);
            this.reference = reference;
            this.referenceCount = referenceCount;
        }

        public StreamStateHandle getReference() {
            return this.reference;
        }

        public int getReferenceCount() {
            return this.referenceCount;
        }

        public String toString() {
            return "Result{reference=" + this.reference + ", referenceCount=" + this.referenceCount + '}';
        }
    }

    private static class SharedStateEntry {
        private final StreamStateHandle stateHandle;
        private int referenceCount;

        SharedStateEntry(StreamStateHandle value) {
            this.stateHandle = value;
            this.referenceCount = 1;
        }

        StreamStateHandle getStateHandle() {
            return this.stateHandle;
        }

        int getReferenceCount() {
            return this.referenceCount;
        }

        void increaseReferenceCount() {
            ++this.referenceCount;
        }

        void decreaseReferenceCount() {
            --this.referenceCount;
        }

        public String toString() {
            return "SharedStateEntry{stateHandle=" + this.stateHandle + ", referenceCount=" + this.referenceCount + '}';
        }
    }
}

