/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import javax.annotation.Nullable;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.RpcServiceSharing;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceUtils;
import org.apache.flink.util.Preconditions;

public class MiniClusterConfiguration {
    private final UnmodifiableConfiguration configuration;
    private final int numTaskManagers;
    private final RpcServiceSharing rpcServiceSharing;
    @Nullable
    private final String commonBindAddress;
    private final MiniCluster.HaServices haServices;

    public MiniClusterConfiguration(Configuration configuration, int numTaskManagers, RpcServiceSharing rpcServiceSharing, @Nullable String commonBindAddress, MiniCluster.HaServices haServices) {
        this.numTaskManagers = numTaskManagers;
        this.configuration = this.generateConfiguration((Configuration)Preconditions.checkNotNull((Object)configuration));
        this.rpcServiceSharing = (RpcServiceSharing)((Object)Preconditions.checkNotNull((Object)((Object)rpcServiceSharing)));
        this.commonBindAddress = commonBindAddress;
        this.haServices = haServices;
    }

    private UnmodifiableConfiguration generateConfiguration(Configuration configuration) {
        Configuration modifiedConfig = new Configuration(configuration);
        TaskExecutorResourceUtils.adjustForLocalExecution(modifiedConfig);
        if (!modifiedConfig.contains(AkkaOptions.ASK_TIMEOUT)) {
            modifiedConfig.set(AkkaOptions.ASK_TIMEOUT, (Object)"5 min");
        }
        return new UnmodifiableConfiguration(modifiedConfig);
    }

    public RpcServiceSharing getRpcServiceSharing() {
        return this.rpcServiceSharing;
    }

    public int getNumTaskManagers() {
        return this.numTaskManagers;
    }

    public String getJobManagerExternalAddress() {
        return this.commonBindAddress != null ? this.commonBindAddress : this.configuration.getString(JobManagerOptions.ADDRESS, "localhost");
    }

    public String getTaskManagerExternalAddress() {
        return this.commonBindAddress != null ? this.commonBindAddress : this.configuration.getString(TaskManagerOptions.HOST, "localhost");
    }

    public String getJobManagerExternalPortRange() {
        return String.valueOf(this.configuration.getInteger(JobManagerOptions.PORT, 0));
    }

    public String getTaskManagerExternalPortRange() {
        return this.configuration.getString(TaskManagerOptions.RPC_PORT);
    }

    public String getJobManagerBindAddress() {
        return this.commonBindAddress != null ? this.commonBindAddress : this.configuration.getString(JobManagerOptions.BIND_HOST, "localhost");
    }

    public String getTaskManagerBindAddress() {
        return this.commonBindAddress != null ? this.commonBindAddress : this.configuration.getString(TaskManagerOptions.BIND_HOST, "localhost");
    }

    public UnmodifiableConfiguration getConfiguration() {
        return this.configuration;
    }

    public MiniCluster.HaServices getHaServices() {
        return this.haServices;
    }

    public String toString() {
        return "MiniClusterConfiguration {singleRpcService=" + (Object)((Object)this.rpcServiceSharing) + ", numTaskManagers=" + this.numTaskManagers + ", commonBindAddress='" + this.commonBindAddress + '\'' + ", config=" + this.configuration + '}';
    }

    public static class Builder {
        private Configuration configuration = new Configuration();
        private int numTaskManagers = 1;
        private int numSlotsPerTaskManager = 1;
        private RpcServiceSharing rpcServiceSharing = RpcServiceSharing.SHARED;
        @Nullable
        private String commonBindAddress = null;
        private MiniCluster.HaServices haServices = MiniCluster.HaServices.CONFIGURED;

        public Builder setConfiguration(Configuration configuration1) {
            this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration1);
            return this;
        }

        public Builder setNumTaskManagers(int numTaskManagers) {
            this.numTaskManagers = numTaskManagers;
            return this;
        }

        public Builder setNumSlotsPerTaskManager(int numSlotsPerTaskManager) {
            this.numSlotsPerTaskManager = numSlotsPerTaskManager;
            return this;
        }

        public Builder setRpcServiceSharing(RpcServiceSharing rpcServiceSharing) {
            this.rpcServiceSharing = (RpcServiceSharing)((Object)Preconditions.checkNotNull((Object)((Object)rpcServiceSharing)));
            return this;
        }

        public Builder setCommonBindAddress(String commonBindAddress) {
            this.commonBindAddress = commonBindAddress;
            return this;
        }

        public Builder setHaServices(MiniCluster.HaServices haServices) {
            this.haServices = haServices;
            return this;
        }

        public MiniClusterConfiguration build() {
            Configuration modifiedConfiguration = new Configuration(this.configuration);
            modifiedConfiguration.setInteger(TaskManagerOptions.NUM_TASK_SLOTS, this.numSlotsPerTaskManager);
            modifiedConfiguration.setString(RestOptions.ADDRESS, modifiedConfiguration.getString(RestOptions.ADDRESS, "localhost"));
            return new MiniClusterConfiguration(modifiedConfiguration, this.numTaskManagers, this.rpcServiceSharing, this.commonBindAddress, this.haServices);
        }
    }
}

