/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.ComponentMetricGroup;
import org.apache.flink.runtime.metrics.groups.OperatorIOMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.util.Preconditions;

@Internal
public class OperatorMetricGroup
extends ComponentMetricGroup<TaskMetricGroup> {
    private final String operatorName;
    private final OperatorID operatorID;
    private final OperatorIOMetricGroup ioMetrics;

    public OperatorMetricGroup(MetricRegistry registry, TaskMetricGroup parent, OperatorID operatorID, String operatorName) {
        super(registry, registry.getScopeFormats().getOperatorFormat().formatScope((TaskMetricGroup)Preconditions.checkNotNull((Object)parent), operatorID, operatorName), parent);
        this.operatorID = operatorID;
        this.operatorName = operatorName;
        this.ioMetrics = new OperatorIOMetricGroup(this);
    }

    public final TaskMetricGroup parent() {
        return (TaskMetricGroup)this.parent;
    }

    @Override
    protected QueryScopeInfo.OperatorQueryScopeInfo createQueryServiceMetricInfo(CharacterFilter filter) {
        return new QueryScopeInfo.OperatorQueryScopeInfo(((TaskManagerJobMetricGroup)((TaskMetricGroup)this.parent).parent).jobId.toString(), ((TaskMetricGroup)this.parent).vertexId.toString(), ((TaskMetricGroup)this.parent).subtaskIndex, filter.filterCharacters(this.operatorName));
    }

    public OperatorIOMetricGroup getIOMetricGroup() {
        return this.ioMetrics;
    }

    @Override
    protected void putVariables(Map<String, String> variables) {
        variables.put(ScopeFormat.SCOPE_OPERATOR_ID, String.valueOf((Object)this.operatorID));
        variables.put(ScopeFormat.SCOPE_OPERATOR_NAME, this.operatorName);
    }

    @Override
    protected Iterable<? extends ComponentMetricGroup> subComponents() {
        return Collections.emptyList();
    }

    @Override
    protected String getGroupName(CharacterFilter filter) {
        return "operator";
    }
}

