/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.io.network.partition.ResourceManagerPartitionTrackerImpl;
import org.apache.flink.runtime.metrics.groups.ResourceManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.ArbitraryWorkerResourceSpecFactory;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerFactory;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServices;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.resourcemanager.StandaloneResourceManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandaloneResourceManagerFactory
extends ResourceManagerFactory<ResourceID> {
    private static final StandaloneResourceManagerFactory INSTANCE = new StandaloneResourceManagerFactory();
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationUtils.class);

    private StandaloneResourceManagerFactory() {
    }

    public static StandaloneResourceManagerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    protected ResourceManager<ResourceID> createResourceManager(Configuration configuration, ResourceID resourceId, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, FatalErrorHandler fatalErrorHandler, ClusterInformation clusterInformation, @Nullable String webInterfaceUrl, ResourceManagerMetricGroup resourceManagerMetricGroup, ResourceManagerRuntimeServices resourceManagerRuntimeServices, Executor ioExecutor) {
        Time standaloneClusterStartupPeriodTime = ConfigurationUtils.getStandaloneClusterStartupPeriodTime((Configuration)configuration);
        return new StandaloneResourceManager(rpcService, resourceId, highAvailabilityServices, heartbeatServices, resourceManagerRuntimeServices.getSlotManager(), ResourceManagerPartitionTrackerImpl::new, resourceManagerRuntimeServices.getJobLeaderIdService(), clusterInformation, fatalErrorHandler, resourceManagerMetricGroup, standaloneClusterStartupPeriodTime, AkkaUtils.getTimeoutAsTime(configuration), ioExecutor);
    }

    @Override
    protected ResourceManagerRuntimeServicesConfiguration createResourceManagerRuntimeServicesConfiguration(Configuration configuration) throws ConfigurationException {
        return ResourceManagerRuntimeServicesConfiguration.fromConfiguration(StandaloneResourceManagerFactory.getConfigurationWithoutMaxSlotNumberIfSet(configuration), ArbitraryWorkerResourceSpecFactory.INSTANCE);
    }

    private static Configuration getConfigurationWithoutMaxSlotNumberIfSet(Configuration configuration) {
        Configuration copiedConfig = new Configuration(configuration);
        if (copiedConfig.removeConfig(ResourceManagerOptions.MAX_SLOT_NUM)) {
            LOG.warn("Config option {} will be ignored in standalone mode.", (Object)ResourceManagerOptions.MAX_SLOT_NUM.key());
        }
        return copiedConfig;
    }
}

