/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.net;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.io.network.netty.SSLHandlerFactory;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.ClientAuth;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.JdkSslContext;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.OpenSsl;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslContext;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslContextBuilder;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslProvider;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.util.FingerprintTrustManagerFactory;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class SSLUtils {
    public static boolean isInternalSSLEnabled(Configuration sslConfig) {
        boolean fallbackFlag = sslConfig.getBoolean(SecurityOptions.SSL_ENABLED);
        return sslConfig.getBoolean(SecurityOptions.SSL_INTERNAL_ENABLED, fallbackFlag);
    }

    public static boolean isRestSSLEnabled(Configuration sslConfig) {
        boolean fallbackFlag = sslConfig.getBoolean(SecurityOptions.SSL_ENABLED);
        return sslConfig.getBoolean(SecurityOptions.SSL_REST_ENABLED, fallbackFlag);
    }

    public static boolean isRestSSLAuthenticationEnabled(Configuration sslConfig) {
        Preconditions.checkNotNull((Object)sslConfig, (String)"sslConfig");
        return SSLUtils.isRestSSLEnabled(sslConfig) && sslConfig.getBoolean(SecurityOptions.SSL_REST_AUTHENTICATION_ENABLED);
    }

    public static ServerSocketFactory createSSLServerSocketFactory(Configuration config) throws Exception {
        SSLContext sslContext = SSLUtils.createInternalSSLContext(config, false);
        if (sslContext == null) {
            throw new IllegalConfigurationException("SSL is not enabled");
        }
        String[] protocols = SSLUtils.getEnabledProtocols(config);
        String[] cipherSuites = SSLUtils.getEnabledCipherSuites(config);
        SSLServerSocketFactory factory = sslContext.getServerSocketFactory();
        return new ConfiguringSSLServerSocketFactory(factory, protocols, cipherSuites);
    }

    public static SocketFactory createSSLClientSocketFactory(Configuration config) throws Exception {
        SSLContext sslContext = SSLUtils.createInternalSSLContext(config, true);
        if (sslContext == null) {
            throw new IllegalConfigurationException("SSL is not enabled");
        }
        return sslContext.getSocketFactory();
    }

    public static SSLHandlerFactory createInternalServerSSLEngineFactory(Configuration config) throws Exception {
        SslContext sslContext = SSLUtils.createInternalNettySSLContext(config, false);
        if (sslContext == null) {
            throw new IllegalConfigurationException("SSL is not enabled for internal communication.");
        }
        return new SSLHandlerFactory(sslContext, config.getInteger(SecurityOptions.SSL_INTERNAL_HANDSHAKE_TIMEOUT), config.getInteger(SecurityOptions.SSL_INTERNAL_CLOSE_NOTIFY_FLUSH_TIMEOUT));
    }

    public static SSLHandlerFactory createInternalClientSSLEngineFactory(Configuration config) throws Exception {
        SslContext sslContext = SSLUtils.createInternalNettySSLContext(config, true);
        if (sslContext == null) {
            throw new IllegalConfigurationException("SSL is not enabled for internal communication.");
        }
        return new SSLHandlerFactory(sslContext, config.getInteger(SecurityOptions.SSL_INTERNAL_HANDSHAKE_TIMEOUT), config.getInteger(SecurityOptions.SSL_INTERNAL_CLOSE_NOTIFY_FLUSH_TIMEOUT));
    }

    public static SSLHandlerFactory createRestServerSSLEngineFactory(Configuration config) throws Exception {
        ClientAuth clientAuth = SSLUtils.isRestSSLAuthenticationEnabled(config) ? ClientAuth.REQUIRE : ClientAuth.NONE;
        SslContext sslContext = SSLUtils.createRestNettySSLContext(config, false, clientAuth);
        if (sslContext == null) {
            throw new IllegalConfigurationException("SSL is not enabled for REST endpoints.");
        }
        return new SSLHandlerFactory(sslContext, -1, -1);
    }

    public static SSLHandlerFactory createRestClientSSLEngineFactory(Configuration config) throws Exception {
        ClientAuth clientAuth = SSLUtils.isRestSSLAuthenticationEnabled(config) ? ClientAuth.REQUIRE : ClientAuth.NONE;
        SslContext sslContext = SSLUtils.createRestNettySSLContext(config, true, clientAuth);
        if (sslContext == null) {
            throw new IllegalConfigurationException("SSL is not enabled for REST endpoints.");
        }
        return new SSLHandlerFactory(sslContext, -1, -1);
    }

    private static String[] getEnabledProtocols(Configuration config) {
        Preconditions.checkNotNull((Object)config, (String)"config must not be null");
        return config.getString(SecurityOptions.SSL_PROTOCOL).split(",");
    }

    private static String[] getEnabledCipherSuites(Configuration config) {
        Preconditions.checkNotNull((Object)config, (String)"config must not be null");
        return config.getString(SecurityOptions.SSL_ALGORITHMS).split(",");
    }

    @VisibleForTesting
    static SslProvider getSSLProvider(Configuration config) {
        Preconditions.checkNotNull((Object)config, (String)"config must not be null");
        String providerString = config.getString(SecurityOptions.SSL_PROVIDER);
        if (providerString.equalsIgnoreCase("OPENSSL")) {
            if (OpenSsl.isAvailable()) {
                return SslProvider.OPENSSL;
            }
            throw new IllegalConfigurationException("openSSL not available", OpenSsl.unavailabilityCause());
        }
        if (providerString.equalsIgnoreCase("JDK")) {
            return SslProvider.JDK;
        }
        throw new IllegalConfigurationException("Unknown SSL provider: %s", new Object[]{providerString});
    }

    private static TrustManagerFactory getTrustManagerFactory(Configuration config, boolean internal) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        String trustStoreFilePath = SSLUtils.getAndCheckOption(config, (ConfigOption<String>)(internal ? SecurityOptions.SSL_INTERNAL_TRUSTSTORE : SecurityOptions.SSL_REST_TRUSTSTORE), (ConfigOption<String>)SecurityOptions.SSL_TRUSTSTORE);
        String trustStorePassword = SSLUtils.getAndCheckOption(config, (ConfigOption<String>)(internal ? SecurityOptions.SSL_INTERNAL_TRUSTSTORE_PASSWORD : SecurityOptions.SSL_REST_TRUSTSTORE_PASSWORD), (ConfigOption<String>)SecurityOptions.SSL_TRUSTSTORE_PASSWORD);
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream trustStoreFile = Files.newInputStream(new File(trustStoreFilePath).toPath(), new OpenOption[0]);){
            trustStore.load(trustStoreFile, trustStorePassword.toCharArray());
        }
        String certFingerprint = config.getString(internal ? SecurityOptions.SSL_INTERNAL_CERT_FINGERPRINT : SecurityOptions.SSL_REST_CERT_FINGERPRINT);
        TrustManagerFactory tmf = StringUtils.isNullOrWhitespaceOnly((String)certFingerprint) ? TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm()) : new FingerprintTrustManagerFactory(certFingerprint.split(","));
        tmf.init(trustStore);
        return tmf;
    }

    private static KeyManagerFactory getKeyManagerFactory(Configuration config, boolean internal, SslProvider provider) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        String keystoreFilePath = SSLUtils.getAndCheckOption(config, (ConfigOption<String>)(internal ? SecurityOptions.SSL_INTERNAL_KEYSTORE : SecurityOptions.SSL_REST_KEYSTORE), (ConfigOption<String>)SecurityOptions.SSL_KEYSTORE);
        String keystorePassword = SSLUtils.getAndCheckOption(config, (ConfigOption<String>)(internal ? SecurityOptions.SSL_INTERNAL_KEYSTORE_PASSWORD : SecurityOptions.SSL_REST_KEYSTORE_PASSWORD), (ConfigOption<String>)SecurityOptions.SSL_KEYSTORE_PASSWORD);
        String certPassword = SSLUtils.getAndCheckOption(config, (ConfigOption<String>)(internal ? SecurityOptions.SSL_INTERNAL_KEY_PASSWORD : SecurityOptions.SSL_REST_KEY_PASSWORD), (ConfigOption<String>)SecurityOptions.SSL_KEY_PASSWORD);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream keyStoreFile = Files.newInputStream(new File(keystoreFilePath).toPath(), new OpenOption[0]);){
            keyStore.load(keyStoreFile, keystorePassword.toCharArray());
        }
        Object kmf = provider == SslProvider.OPENSSL || provider == SslProvider.OPENSSL_REFCNT ? new OpenSslX509KeyManagerFactory() : KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        ((KeyManagerFactory)kmf).init(keyStore, certPassword.toCharArray());
        return kmf;
    }

    @Nullable
    private static SSLContext createInternalSSLContext(Configuration config, boolean clientMode) throws Exception {
        JdkSslContext nettySSLContext = (JdkSslContext)SSLUtils.createInternalNettySSLContext(config, clientMode, SslProvider.JDK);
        if (nettySSLContext != null) {
            return nettySSLContext.context();
        }
        return null;
    }

    @Nullable
    private static SslContext createInternalNettySSLContext(Configuration config, boolean clientMode) throws Exception {
        return SSLUtils.createInternalNettySSLContext(config, clientMode, SSLUtils.getSSLProvider(config));
    }

    @Nullable
    private static SslContext createInternalNettySSLContext(Configuration config, boolean clientMode, SslProvider provider) throws Exception {
        Preconditions.checkNotNull((Object)config, (String)"config");
        if (!SSLUtils.isInternalSSLEnabled(config)) {
            return null;
        }
        String[] sslProtocols = SSLUtils.getEnabledProtocols(config);
        List<String> ciphers = Arrays.asList(SSLUtils.getEnabledCipherSuites(config));
        int sessionCacheSize = config.getInteger(SecurityOptions.SSL_INTERNAL_SESSION_CACHE_SIZE);
        int sessionTimeoutMs = config.getInteger(SecurityOptions.SSL_INTERNAL_SESSION_TIMEOUT);
        KeyManagerFactory kmf = SSLUtils.getKeyManagerFactory(config, true, provider);
        TrustManagerFactory tmf = SSLUtils.getTrustManagerFactory(config, true);
        ClientAuth clientAuth = ClientAuth.REQUIRE;
        SslContextBuilder sslContextBuilder = clientMode ? SslContextBuilder.forClient().keyManager(kmf) : SslContextBuilder.forServer((KeyManagerFactory)kmf);
        return sslContextBuilder.sslProvider(provider).protocols(sslProtocols).ciphers(ciphers).trustManager(tmf).clientAuth(clientAuth).sessionCacheSize((long)sessionCacheSize).sessionTimeout((long)(sessionTimeoutMs / 1000)).build();
    }

    @Nullable
    @VisibleForTesting
    public static SSLContext createRestSSLContext(Configuration config, boolean clientMode) throws Exception {
        ClientAuth clientAuth = SSLUtils.isRestSSLAuthenticationEnabled(config) ? ClientAuth.REQUIRE : ClientAuth.NONE;
        JdkSslContext nettySSLContext = (JdkSslContext)SSLUtils.createRestNettySSLContext(config, clientMode, clientAuth, SslProvider.JDK);
        if (nettySSLContext != null) {
            return nettySSLContext.context();
        }
        return null;
    }

    @Nullable
    private static SslContext createRestNettySSLContext(Configuration config, boolean clientMode, ClientAuth clientAuth) throws Exception {
        return SSLUtils.createRestNettySSLContext(config, clientMode, clientAuth, SSLUtils.getSSLProvider(config));
    }

    @Nullable
    public static SslContext createRestNettySSLContext(Configuration config, boolean clientMode, ClientAuth clientAuth, SslProvider provider) throws Exception {
        KeyManagerFactory kmf;
        SslContextBuilder sslContextBuilder;
        Preconditions.checkNotNull((Object)config, (String)"config");
        if (!SSLUtils.isRestSSLEnabled(config)) {
            return null;
        }
        String[] sslProtocols = SSLUtils.getEnabledProtocols(config);
        if (clientMode) {
            sslContextBuilder = SslContextBuilder.forClient();
            if (clientAuth != ClientAuth.NONE) {
                kmf = SSLUtils.getKeyManagerFactory(config, false, provider);
                sslContextBuilder.keyManager(kmf);
            }
        } else {
            kmf = SSLUtils.getKeyManagerFactory(config, false, provider);
            sslContextBuilder = SslContextBuilder.forServer((KeyManagerFactory)kmf);
        }
        if (clientMode || clientAuth != ClientAuth.NONE) {
            TrustManagerFactory tmf = SSLUtils.getTrustManagerFactory(config, false);
            sslContextBuilder.trustManager(tmf);
        }
        return sslContextBuilder.sslProvider(provider).protocols(sslProtocols).clientAuth(clientAuth).build();
    }

    private static String getAndCheckOption(Configuration config, ConfigOption<String> primaryOption, ConfigOption<String> fallbackOption) {
        String value = config.getString(primaryOption, config.getString(fallbackOption));
        if (value != null) {
            return value;
        }
        throw new IllegalConfigurationException("The config option " + primaryOption.key() + " or " + fallbackOption.key() + " is missing.");
    }

    private static class ConfiguringSSLServerSocketFactory
    extends ServerSocketFactory {
        private final SSLServerSocketFactory sslServerSocketFactory;
        private final String[] protocols;
        private final String[] cipherSuites;

        ConfiguringSSLServerSocketFactory(SSLServerSocketFactory sslServerSocketFactory, String[] protocols, String[] cipherSuites) {
            this.sslServerSocketFactory = sslServerSocketFactory;
            this.protocols = protocols;
            this.cipherSuites = cipherSuites;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            SSLServerSocket socket = (SSLServerSocket)this.sslServerSocketFactory.createServerSocket(port);
            this.configureServerSocket(socket);
            return socket;
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog) throws IOException {
            SSLServerSocket socket = (SSLServerSocket)this.sslServerSocketFactory.createServerSocket(port, backlog);
            this.configureServerSocket(socket);
            return socket;
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
            SSLServerSocket socket = (SSLServerSocket)this.sslServerSocketFactory.createServerSocket(port, backlog, ifAddress);
            this.configureServerSocket(socket);
            return socket;
        }

        private void configureServerSocket(SSLServerSocket socket) {
            socket.setEnabledProtocols(this.protocols);
            socket.setEnabledCipherSuites(this.cipherSuites);
            socket.setNeedClientAuth(true);
        }
    }
}

