/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.View;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class TimerGauge
implements Gauge<Long>,
View {
    private final Clock clock;
    private long previousCount;
    private long currentCount;
    private long currentMeasurementStart;

    public TimerGauge() {
        this((Clock)SystemClock.getInstance());
    }

    public TimerGauge(Clock clock) {
        this.clock = clock;
    }

    public synchronized void markStart() {
        if (this.currentMeasurementStart == 0L) {
            this.currentMeasurementStart = this.clock.absoluteTimeMillis();
        }
    }

    public synchronized void markEnd() {
        if (this.currentMeasurementStart != 0L) {
            this.currentCount += this.clock.absoluteTimeMillis() - this.currentMeasurementStart;
            this.currentMeasurementStart = 0L;
        }
    }

    public synchronized void update() {
        if (this.currentMeasurementStart != 0L) {
            long now = this.clock.absoluteTimeMillis();
            this.currentCount += now - this.currentMeasurementStart;
            this.currentMeasurementStart = now;
        }
        this.previousCount = Math.max(Math.min(this.currentCount / 5L, 1000L), 0L);
        this.currentCount = 0L;
    }

    public synchronized Long getValue() {
        return this.previousCount;
    }

    @VisibleForTesting
    public synchronized long getCount() {
        return this.currentCount;
    }

    @VisibleForTesting
    public synchronized boolean isMeasuring() {
        return this.currentMeasurementStart != 0L;
    }
}

