/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.util.Preconditions;

public class InputGateDeploymentDescriptor
implements Serializable {
    private static final long serialVersionUID = -7143441863165366704L;
    private final IntermediateDataSetID consumedResultId;
    private final ResultPartitionType consumedPartitionType;
    @Nonnegative
    private final int consumedSubpartitionIndex;
    private final ShuffleDescriptor[] inputChannels;

    public InputGateDeploymentDescriptor(IntermediateDataSetID consumedResultId, ResultPartitionType consumedPartitionType, @Nonnegative int consumedSubpartitionIndex, ShuffleDescriptor[] inputChannels) {
        this.consumedResultId = (IntermediateDataSetID)Preconditions.checkNotNull((Object)consumedResultId);
        this.consumedPartitionType = (ResultPartitionType)((Object)Preconditions.checkNotNull((Object)((Object)consumedPartitionType)));
        this.consumedSubpartitionIndex = consumedSubpartitionIndex;
        this.inputChannels = (ShuffleDescriptor[])Preconditions.checkNotNull((Object)inputChannels);
    }

    public IntermediateDataSetID getConsumedResultId() {
        return this.consumedResultId;
    }

    public ResultPartitionType getConsumedPartitionType() {
        return this.consumedPartitionType;
    }

    @Nonnegative
    public int getConsumedSubpartitionIndex() {
        return this.consumedSubpartitionIndex;
    }

    public ShuffleDescriptor[] getShuffleDescriptors() {
        return this.inputChannels;
    }

    public String toString() {
        return String.format("InputGateDeploymentDescriptor [result id: %s, consumed subpartition index: %d, input channels: %s]", this.consumedResultId.toString(), this.consumedSubpartitionIndex, Arrays.toString(this.inputChannels));
    }
}

