/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.types.Either;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface BlobWriter {
    public static final Logger LOG = LoggerFactory.getLogger(BlobWriter.class);

    public PermanentBlobKey putPermanent(JobID var1, byte[] var2) throws IOException;

    public PermanentBlobKey putPermanent(JobID var1, InputStream var2) throws IOException;

    public int getMinOffloadingSize();

    public static <T> Either<SerializedValue<T>, PermanentBlobKey> serializeAndTryOffload(T value, JobID jobId, BlobWriter blobWriter) throws IOException {
        Preconditions.checkNotNull(value);
        Preconditions.checkNotNull((Object)jobId);
        Preconditions.checkNotNull((Object)blobWriter);
        SerializedValue serializedValue = new SerializedValue(value);
        if (serializedValue.getByteArray().length < blobWriter.getMinOffloadingSize()) {
            return Either.Left((Object)serializedValue);
        }
        try {
            PermanentBlobKey permanentBlobKey = blobWriter.putPermanent(jobId, serializedValue.getByteArray());
            return Either.Right((Object)permanentBlobKey);
        }
        catch (IOException e) {
            LOG.warn("Failed to offload value {} for job {} to BLOB store.", new Object[]{value, jobId, e});
            return Either.Left((Object)serializedValue);
        }
    }
}

