/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.RetrievableStateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

public class RetrievableStreamStateHandle<T extends Serializable>
implements StreamStateHandle,
RetrievableStateHandle<T>,
Closeable {
    private static final long serialVersionUID = 314567453677355L;
    private final StreamStateHandle wrappedStreamStateHandle;

    public RetrievableStreamStateHandle(StreamStateHandle streamStateHandle) {
        this.wrappedStreamStateHandle = (StreamStateHandle)Preconditions.checkNotNull((Object)streamStateHandle);
    }

    public RetrievableStreamStateHandle(Path filePath, long stateSize) {
        Preconditions.checkNotNull((Object)filePath);
        this.wrappedStreamStateHandle = new FileStateHandle(filePath, stateSize);
    }

    @Override
    public T retrieveState() throws IOException, ClassNotFoundException {
        try (FSDataInputStream in = this.openInputStream();){
            Serializable serializable = (Serializable)InstantiationUtil.deserializeObject((InputStream)in, (ClassLoader)Thread.currentThread().getContextClassLoader());
            return (T)serializable;
        }
    }

    @Override
    public FSDataInputStream openInputStream() throws IOException {
        return this.wrappedStreamStateHandle.openInputStream();
    }

    @Override
    public void discardState() throws Exception {
        this.wrappedStreamStateHandle.discardState();
    }

    @Override
    public long getStateSize() {
        return this.wrappedStreamStateHandle.getStateSize();
    }

    @Override
    public void close() throws IOException {
    }
}

