/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.restart;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.executiongraph.restart.RestartCallback;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.util.Preconditions;

public class FixedDelayRestartStrategy
implements RestartStrategy {
    private final int maxNumberRestartAttempts;
    private final long delayBetweenRestartAttempts;
    private int currentRestartAttempt;

    public FixedDelayRestartStrategy(int maxNumberRestartAttempts, long delayBetweenRestartAttempts) {
        Preconditions.checkArgument((maxNumberRestartAttempts >= 0 ? 1 : 0) != 0, (Object)"Maximum number of restart attempts must be positive.");
        Preconditions.checkArgument((delayBetweenRestartAttempts >= 0L ? 1 : 0) != 0, (Object)"Delay between restart attempts must be positive");
        this.maxNumberRestartAttempts = maxNumberRestartAttempts;
        this.delayBetweenRestartAttempts = delayBetweenRestartAttempts;
        this.currentRestartAttempt = 0;
    }

    public int getCurrentRestartAttempt() {
        return this.currentRestartAttempt;
    }

    @Override
    public boolean canRestart() {
        return this.currentRestartAttempt < this.maxNumberRestartAttempts;
    }

    @Override
    public CompletableFuture<Void> restart(RestartCallback restarter, ScheduledExecutor executor) {
        ++this.currentRestartAttempt;
        return FutureUtils.scheduleWithDelay(restarter::triggerFullRecovery, Time.milliseconds((long)this.delayBetweenRestartAttempts), executor);
    }

    public static FixedDelayRestartStrategyFactory createFactory(Configuration configuration) throws Exception {
        int maxAttempts = configuration.getInteger(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS);
        long delay = ((Duration)configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_DELAY)).toMillis();
        return new FixedDelayRestartStrategyFactory(maxAttempts, delay);
    }

    public String toString() {
        return "FixedDelayRestartStrategy(maxNumberRestartAttempts=" + this.maxNumberRestartAttempts + ", delayBetweenRestartAttempts=" + this.delayBetweenRestartAttempts + ')';
    }

    public static class FixedDelayRestartStrategyFactory
    extends RestartStrategyFactory {
        private static final long serialVersionUID = 6642934067762271950L;
        private final int maxNumberRestartAttempts;
        private final long delayBetweenRestartAttempts;

        public FixedDelayRestartStrategyFactory(int maxNumberRestartAttempts, long delayBetweenRestartAttempts) {
            this.maxNumberRestartAttempts = maxNumberRestartAttempts;
            this.delayBetweenRestartAttempts = delayBetweenRestartAttempts;
        }

        @Override
        public RestartStrategy createRestartStrategy() {
            return new FixedDelayRestartStrategy(this.maxNumberRestartAttempts, this.delayBetweenRestartAttempts);
        }

        int getMaxNumberRestartAttempts() {
            return this.maxNumberRestartAttempts;
        }

        long getDelayBetweenRestartAttempts() {
            return this.delayBetweenRestartAttempts;
        }
    }
}

