/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailoverStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.RestartAllStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.RestartPipelinedRegionStrategy;
import org.apache.flink.util.Preconditions;

public final class FailoverStrategyFactoryLoader {
    public static final String FULL_RESTART_STRATEGY_NAME = "full";
    public static final String PIPELINED_REGION_RESTART_STRATEGY_NAME = "region";

    private FailoverStrategyFactoryLoader() {
    }

    public static FailoverStrategy.Factory loadFailoverStrategyFactory(Configuration config) {
        Preconditions.checkNotNull((Object)config);
        String strategyParam = config.getString(JobManagerOptions.EXECUTION_FAILOVER_STRATEGY, PIPELINED_REGION_RESTART_STRATEGY_NAME);
        switch (strategyParam.toLowerCase()) {
            case "full": {
                return new RestartAllStrategy.Factory();
            }
            case "region": {
                return new RestartPipelinedRegionStrategy.Factory();
            }
        }
        throw new IllegalConfigurationException("Unknown failover strategy: " + strategyParam);
    }
}

