/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover;

import java.util.List;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.failover.FailoverStrategy;
import org.apache.flink.util.Preconditions;

public class RestartAllStrategy
extends FailoverStrategy {
    private final ExecutionGraph executionGraph;

    public RestartAllStrategy(ExecutionGraph executionGraph) {
        this.executionGraph = (ExecutionGraph)Preconditions.checkNotNull((Object)executionGraph);
    }

    @Override
    public void onTaskFailure(Execution taskExecution, Throwable cause) {
        this.executionGraph.failGlobal(cause);
    }

    @Override
    public void notifyNewVertices(List<ExecutionJobVertex> newJobVerticesTopological) {
    }

    @Override
    public String getStrategyName() {
        return "full graph restart";
    }

    public static class Factory
    implements FailoverStrategy.Factory {
        @Override
        public FailoverStrategy create(ExecutionGraph executionGraph) {
            return new RestartAllStrategy(executionGraph);
        }
    }
}

