/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.MinMaxAvgStats;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public class TaskStateStats
implements Serializable {
    private static final long serialVersionUID = 531803101206574444L;
    private final JobVertexID jobVertexId;
    private final SubtaskStateStats[] subtaskStats;
    private final TaskStateStatsSummary summaryStats = new TaskStateStatsSummary();
    private int numAcknowledgedSubtasks;
    @Nullable
    private SubtaskStateStats latestAckedSubtaskStats;

    TaskStateStats(JobVertexID jobVertexId, int numSubtasks) {
        this.jobVertexId = (JobVertexID)Preconditions.checkNotNull((Object)jobVertexId, (String)"JobVertexID");
        Preconditions.checkArgument((numSubtasks > 0 ? 1 : 0) != 0, (Object)"Number of subtasks <= 0");
        this.subtaskStats = new SubtaskStateStats[numSubtasks];
    }

    boolean reportSubtaskStats(SubtaskStateStats subtask) {
        Preconditions.checkNotNull((Object)subtask, (String)"Subtask stats");
        int subtaskIndex = subtask.getSubtaskIndex();
        if (subtaskIndex < 0 || subtaskIndex >= this.subtaskStats.length) {
            return false;
        }
        if (this.subtaskStats[subtaskIndex] == null) {
            this.subtaskStats[subtaskIndex] = subtask;
            this.latestAckedSubtaskStats = subtask;
            ++this.numAcknowledgedSubtasks;
            this.summaryStats.updateSummary(subtask);
            return true;
        }
        return false;
    }

    public JobVertexID getJobVertexId() {
        return this.jobVertexId;
    }

    public int getNumberOfSubtasks() {
        return this.subtaskStats.length;
    }

    public int getNumberOfAcknowledgedSubtasks() {
        return this.numAcknowledgedSubtasks;
    }

    @Nullable
    public SubtaskStateStats getLatestAcknowledgedSubtaskStats() {
        return this.latestAckedSubtaskStats;
    }

    public long getLatestAckTimestamp() {
        SubtaskStateStats subtask = this.latestAckedSubtaskStats;
        if (subtask != null) {
            return subtask.getAckTimestamp();
        }
        return -1L;
    }

    public long getStateSize() {
        return this.summaryStats.getStateSizeStats().getSum();
    }

    public long getAlignmentBuffered() {
        return this.summaryStats.getAlignmentBufferedStats().getSum();
    }

    public long getEndToEndDuration(long triggerTimestamp) {
        SubtaskStateStats subtask = this.getLatestAcknowledgedSubtaskStats();
        if (subtask != null) {
            return Math.max(0L, subtask.getAckTimestamp() - triggerTimestamp);
        }
        return -1L;
    }

    public SubtaskStateStats[] getSubtaskStats() {
        return this.subtaskStats;
    }

    public TaskStateStatsSummary getSummaryStats() {
        return this.summaryStats;
    }

    public static class TaskStateStatsSummary
    implements Serializable {
        private static final long serialVersionUID = 1009476026522091909L;
        private MinMaxAvgStats stateSize = new MinMaxAvgStats();
        private MinMaxAvgStats ackTimestamp = new MinMaxAvgStats();
        private MinMaxAvgStats syncCheckpointDuration = new MinMaxAvgStats();
        private MinMaxAvgStats asyncCheckpointDuration = new MinMaxAvgStats();
        private MinMaxAvgStats alignmentBuffered = new MinMaxAvgStats();
        private MinMaxAvgStats alignmentDuration = new MinMaxAvgStats();

        void updateSummary(SubtaskStateStats subtaskStats) {
            this.stateSize.add(subtaskStats.getStateSize());
            this.ackTimestamp.add(subtaskStats.getAckTimestamp());
            this.syncCheckpointDuration.add(subtaskStats.getSyncCheckpointDuration());
            this.asyncCheckpointDuration.add(subtaskStats.getAsyncCheckpointDuration());
            this.alignmentBuffered.add(subtaskStats.getAlignmentBuffered());
            this.alignmentDuration.add(subtaskStats.getAlignmentDuration());
        }

        public MinMaxAvgStats getStateSizeStats() {
            return this.stateSize;
        }

        public MinMaxAvgStats getAckTimestampStats() {
            return this.ackTimestamp;
        }

        public MinMaxAvgStats getSyncCheckpointDurationStats() {
            return this.syncCheckpointDuration;
        }

        public MinMaxAvgStats getAsyncCheckpointDurationStats() {
            return this.asyncCheckpointDuration;
        }

        public MinMaxAvgStats getAlignmentBufferedStats() {
            return this.alignmentBuffered;
        }

        public MinMaxAvgStats getAlignmentDurationStats() {
            return this.alignmentDuration;
        }
    }
}

