/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.util.Preconditions;

public class InputGateWithMetrics
extends InputGate {
    private final InputGate inputGate;
    private final Counter numBytesIn;

    public InputGateWithMetrics(InputGate inputGate, Counter numBytesIn) {
        this.inputGate = (InputGate)Preconditions.checkNotNull((Object)inputGate);
        this.numBytesIn = (Counter)Preconditions.checkNotNull((Object)numBytesIn);
    }

    @Override
    public CompletableFuture<?> getAvailableFuture() {
        return this.inputGate.getAvailableFuture();
    }

    @Override
    public int getNumberOfInputChannels() {
        return this.inputGate.getNumberOfInputChannels();
    }

    @Override
    public boolean isFinished() {
        return this.inputGate.isFinished();
    }

    @Override
    public void setup() throws IOException, InterruptedException {
        this.inputGate.setup();
    }

    @Override
    public Optional<BufferOrEvent> getNext() throws IOException, InterruptedException {
        return this.inputGate.getNext().map(this::updateMetrics);
    }

    @Override
    public Optional<BufferOrEvent> pollNext() throws IOException, InterruptedException {
        return this.inputGate.pollNext().map(this::updateMetrics);
    }

    @Override
    public void sendTaskEvent(TaskEvent event) throws IOException {
        this.inputGate.sendTaskEvent(event);
    }

    @Override
    public void close() throws Exception {
        this.inputGate.close();
    }

    private BufferOrEvent updateMetrics(BufferOrEvent bufferOrEvent) {
        this.numBytesIn.inc((long)bufferOrEvent.getSize());
        return bufferOrEvent;
    }
}

