/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.PartitionNotFoundException;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultPartitionManager
implements ResultPartitionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ResultPartitionManager.class);
    private final Map<ResultPartitionID, ResultPartition> registeredPartitions = new HashMap<ResultPartitionID, ResultPartition>(16);
    private boolean isShutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResultPartition(ResultPartition partition) {
        Map<ResultPartitionID, ResultPartition> map = this.registeredPartitions;
        synchronized (map) {
            Preconditions.checkState((!this.isShutdown ? 1 : 0) != 0, (Object)"Result partition manager already shut down.");
            ResultPartition previous = this.registeredPartitions.put(partition.getPartitionId(), partition);
            if (previous != null) {
                throw new IllegalStateException("Result partition already registered.");
            }
            LOG.debug("Registered {}.", (Object)partition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSubpartitionView createSubpartitionView(ResultPartitionID partitionId, int subpartitionIndex, BufferAvailabilityListener availabilityListener) throws IOException {
        Map<ResultPartitionID, ResultPartition> map = this.registeredPartitions;
        synchronized (map) {
            ResultPartition partition = this.registeredPartitions.get(partitionId);
            if (partition == null) {
                throw new PartitionNotFoundException(partitionId);
            }
            LOG.debug("Requesting subpartition {} of {}.", (Object)subpartitionIndex, (Object)partition);
            return partition.createSubpartitionView(subpartitionIndex, availabilityListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePartition(ResultPartitionID partitionId, Throwable cause) {
        Map<ResultPartitionID, ResultPartition> map = this.registeredPartitions;
        synchronized (map) {
            ResultPartition resultPartition = this.registeredPartitions.remove(partitionId);
            if (resultPartition != null) {
                resultPartition.release(cause);
                LOG.debug("Released partition {} produced by {}.", (Object)partitionId.getPartitionId(), (Object)partitionId.getProducerId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Map<ResultPartitionID, ResultPartition> map = this.registeredPartitions;
        synchronized (map) {
            LOG.debug("Releasing {} partitions because of shutdown.", (Object)this.registeredPartitions.values().size());
            for (ResultPartition partition : this.registeredPartitions.values()) {
                partition.release();
            }
            this.registeredPartitions.clear();
            this.isShutdown = true;
            LOG.debug("Successful shutdown.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onConsumedPartition(ResultPartition partition) {
        LOG.debug("Received consume notification from {}.", (Object)partition);
        Map<ResultPartitionID, ResultPartition> map = this.registeredPartitions;
        synchronized (map) {
            ResultPartition previous = this.registeredPartitions.remove(partition.getPartitionId());
            if (partition == previous) {
                partition.release();
                ResultPartitionID partitionId = partition.getPartitionId();
                LOG.debug("Released partition {} produced by {}.", (Object)partitionId.getPartitionId(), (Object)partitionId.getProducerId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ResultPartitionID> getUnreleasedPartitions() {
        Map<ResultPartitionID, ResultPartition> map = this.registeredPartitions;
        synchronized (map) {
            return this.registeredPartitions.keySet();
        }
    }
}

