/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.event.RuntimeEvent;
import org.apache.flink.util.Preconditions;

public class CheckpointBarrier
extends RuntimeEvent {
    private final long id;
    private final long timestamp;
    private final CheckpointOptions checkpointOptions;

    public CheckpointBarrier(long id, long timestamp, CheckpointOptions checkpointOptions) {
        this.id = id;
        this.timestamp = timestamp;
        this.checkpointOptions = (CheckpointOptions)Preconditions.checkNotNull((Object)checkpointOptions);
    }

    public long getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public CheckpointOptions getCheckpointOptions() {
        return this.checkpointOptions;
    }

    public void write(DataOutputView out) throws IOException {
        throw new UnsupportedOperationException("This method should never be called");
    }

    public void read(DataInputView in) throws IOException {
        throw new UnsupportedOperationException("This method should never be called");
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32 ^ this.timestamp ^ this.timestamp >>> 32);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != CheckpointBarrier.class) {
            return false;
        }
        CheckpointBarrier that = (CheckpointBarrier)other;
        return that.id == this.id && that.timestamp == this.timestamp && this.checkpointOptions.equals(that.checkpointOptions);
    }

    public String toString() {
        return String.format("CheckpointBarrier %d @ %d Options: %s", this.id, this.timestamp, this.checkpointOptions);
    }
}

