/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.restart;

import java.time.Duration;
import java.util.ArrayDeque;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.executiongraph.restart.RestartCallback;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.util.Preconditions;

public class FailureRateRestartStrategy
implements RestartStrategy {
    private final Time failuresInterval;
    private final Time delayInterval;
    private final int maxFailuresPerInterval;
    private final ArrayDeque<Long> restartTimestampsDeque;

    public FailureRateRestartStrategy(int maxFailuresPerInterval, Time failuresInterval, Time delayInterval) {
        Preconditions.checkNotNull((Object)failuresInterval, (String)"Failures interval cannot be null.");
        Preconditions.checkNotNull((Object)delayInterval, (String)"Delay interval cannot be null.");
        Preconditions.checkArgument((maxFailuresPerInterval > 0 ? 1 : 0) != 0, (Object)"Maximum number of restart attempts per time unit must be greater than 0.");
        Preconditions.checkArgument((failuresInterval.getSize() > 0L ? 1 : 0) != 0, (Object)"Failures interval must be greater than 0 ms.");
        Preconditions.checkArgument((delayInterval.getSize() >= 0L ? 1 : 0) != 0, (Object)"Delay interval must be at least 0 ms.");
        this.failuresInterval = failuresInterval;
        this.delayInterval = delayInterval;
        this.maxFailuresPerInterval = maxFailuresPerInterval;
        this.restartTimestampsDeque = new ArrayDeque(maxFailuresPerInterval);
    }

    @Override
    public boolean canRestart() {
        if (this.isRestartTimestampsQueueFull()) {
            Long now = System.currentTimeMillis();
            Long earliestFailure = this.restartTimestampsDeque.peek();
            return now - earliestFailure > this.failuresInterval.toMilliseconds();
        }
        return true;
    }

    @Override
    public CompletableFuture<Void> restart(RestartCallback restarter, ScheduledExecutor executor) {
        if (this.isRestartTimestampsQueueFull()) {
            this.restartTimestampsDeque.remove();
        }
        this.restartTimestampsDeque.add(System.currentTimeMillis());
        return FutureUtils.scheduleWithDelay(restarter::triggerFullRecovery, this.delayInterval, executor);
    }

    private boolean isRestartTimestampsQueueFull() {
        return this.restartTimestampsDeque.size() >= this.maxFailuresPerInterval;
    }

    public String toString() {
        return "FailureRateRestartStrategy(failuresInterval=" + this.failuresInterval + "delayInterval=" + this.delayInterval + "maxFailuresPerInterval=" + this.maxFailuresPerInterval + ")";
    }

    public static FailureRateRestartStrategyFactory createFactory(Configuration configuration) throws Exception {
        int maxFailuresPerInterval = configuration.getInteger(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_MAX_FAILURES_PER_INTERVAL);
        long failuresInterval = ((Duration)configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_FAILURE_RATE_INTERVAL)).toMillis();
        long delay = ((Duration)configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_DELAY)).toMillis();
        return new FailureRateRestartStrategyFactory(maxFailuresPerInterval, Time.milliseconds((long)failuresInterval), Time.milliseconds((long)delay));
    }

    public static class FailureRateRestartStrategyFactory
    extends RestartStrategyFactory {
        private static final long serialVersionUID = -373724639430960480L;
        private final int maxFailuresPerInterval;
        private final Time failuresInterval;
        private final Time delayInterval;

        public FailureRateRestartStrategyFactory(int maxFailuresPerInterval, Time failuresInterval, Time delayInterval) {
            this.maxFailuresPerInterval = maxFailuresPerInterval;
            this.failuresInterval = (Time)Preconditions.checkNotNull((Object)failuresInterval);
            this.delayInterval = (Time)Preconditions.checkNotNull((Object)delayInterval);
        }

        @Override
        public RestartStrategy createRestartStrategy() {
            return new FailureRateRestartStrategy(this.maxFailuresPerInterval, this.failuresInterval, this.delayInterval);
        }
    }
}

