/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.metrics.groups.ResourceManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.FlinkException;

public abstract class ActiveResourceManager<WorkerType extends ResourceIDRetrievable>
extends ResourceManager<WorkerType> {
    protected final Map<String, String> env;
    protected final int numSlotsPerTaskManager;
    protected final TaskExecutorProcessSpec taskExecutorProcessSpec;
    protected final int defaultMemoryMB;
    protected final Collection<ResourceProfile> resourceProfilesPerWorker;
    protected final Configuration flinkConfig;
    protected final Configuration flinkClientConfig;

    public ActiveResourceManager(Configuration flinkConfig, Map<String, String> env, RpcService rpcService, String resourceManagerEndpointId, ResourceID resourceId, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, SlotManager slotManager, JobLeaderIdService jobLeaderIdService, ClusterInformation clusterInformation, FatalErrorHandler fatalErrorHandler, ResourceManagerMetricGroup resourceManagerMetricGroup) {
        super(rpcService, resourceManagerEndpointId, resourceId, highAvailabilityServices, heartbeatServices, slotManager, jobLeaderIdService, clusterInformation, fatalErrorHandler, resourceManagerMetricGroup);
        this.flinkConfig = flinkConfig;
        this.env = env;
        this.numSlotsPerTaskManager = flinkConfig.getInteger(TaskManagerOptions.NUM_TASK_SLOTS);
        double defaultCpus = this.getCpuCores(flinkConfig);
        this.taskExecutorProcessSpec = TaskExecutorProcessUtils.newProcessSpecBuilder(flinkConfig).withCpuCores(defaultCpus).build();
        this.defaultMemoryMB = this.taskExecutorProcessSpec.getTotalProcessMemorySize().getMebiBytes();
        this.resourceProfilesPerWorker = TaskExecutorProcessUtils.createDefaultWorkerSlotProfiles(this.taskExecutorProcessSpec, this.numSlotsPerTaskManager);
        this.flinkClientConfig = this.loadClientConfiguration();
    }

    protected CompletableFuture<Void> getStopTerminationFutureOrCompletedExceptionally(@Nullable Throwable exception) {
        CompletableFuture<Void> terminationFuture = super.onStop();
        if (exception != null) {
            return FutureUtils.completedExceptionally(new FlinkException("Error while shutting down resource manager", exception));
        }
        return terminationFuture;
    }

    protected abstract Configuration loadClientConfiguration();

    protected abstract double getCpuCores(Configuration var1);
}

