/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.runtime.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.ProxyMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;

public class OperatorIOMetricGroup
extends ProxyMetricGroup<OperatorMetricGroup> {
    private final Counter numRecordsIn;
    private final Counter numRecordsOut;
    private final Meter numRecordsInRate;
    private final Meter numRecordsOutRate;

    public OperatorIOMetricGroup(OperatorMetricGroup parentMetricGroup) {
        super(parentMetricGroup);
        this.numRecordsIn = parentMetricGroup.counter("numRecordsIn");
        this.numRecordsOut = parentMetricGroup.counter("numRecordsOut");
        this.numRecordsInRate = parentMetricGroup.meter("numRecordsInPerSecond", new MeterView(this.numRecordsIn));
        this.numRecordsOutRate = parentMetricGroup.meter("numRecordsOutPerSecond", new MeterView(this.numRecordsOut));
    }

    public Counter getNumRecordsInCounter() {
        return this.numRecordsIn;
    }

    public Counter getNumRecordsOutCounter() {
        return this.numRecordsOut;
    }

    public Meter getNumRecordsInRateMeter() {
        return this.numRecordsInRate;
    }

    public Meter getNumRecordsOutRate() {
        return this.numRecordsOutRate;
    }

    public void reuseInputMetricsForTask() {
        TaskIOMetricGroup taskIO = ((OperatorMetricGroup)this.parentMetricGroup).parent().getIOMetricGroup();
        taskIO.reuseRecordsInputCounter(this.numRecordsIn);
    }

    public void reuseOutputMetricsForTask() {
        TaskIOMetricGroup taskIO = ((OperatorMetricGroup)this.parentMetricGroup).parent().getIOMetricGroup();
        taskIO.reuseRecordsOutputCounter(this.numRecordsOut);
    }
}

