/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.zookeeper;

import java.io.Serializable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.zookeeper.RetrievableStateStorageHelper;
import org.apache.flink.runtime.zookeeper.ZooKeeperSharedCount;
import org.apache.flink.runtime.zookeeper.ZooKeeperSharedValue;
import org.apache.flink.runtime.zookeeper.ZooKeeperStateHandleStore;
import org.apache.flink.shaded.curator.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator.org.apache.curator.framework.recipes.shared.SharedCount;
import org.apache.flink.shaded.curator.org.apache.curator.framework.recipes.shared.SharedValue;
import org.apache.flink.util.Preconditions;

public class ZooKeeperUtilityFactory {
    private final CuratorFramework root;
    private final CuratorFramework facade;

    public ZooKeeperUtilityFactory(Configuration configuration, String path) throws Exception {
        Preconditions.checkNotNull((Object)path, (String)"path");
        this.root = ZooKeeperUtils.startCuratorFramework(configuration);
        this.root.newNamespaceAwareEnsurePath(path).ensure(this.root.getZookeeperClient());
        this.facade = this.root.usingNamespace(ZooKeeperUtils.generateZookeeperPath(this.root.getNamespace(), path));
    }

    public void close(boolean cleanup) throws Exception {
        if (cleanup) {
            this.facade.delete().deletingChildrenIfNeeded().forPath("/");
        }
        this.root.close();
    }

    public <T extends Serializable> ZooKeeperStateHandleStore<T> createZooKeeperStateHandleStore(String zkStateHandleStorePath, RetrievableStateStorageHelper<T> stateStorageHelper) throws Exception {
        return ZooKeeperUtils.createZooKeeperStateHandleStore(this.facade, zkStateHandleStorePath, stateStorageHelper);
    }

    public ZooKeeperSharedValue createSharedValue(String path, byte[] seedValue) {
        return new ZooKeeperSharedValue(new SharedValue(this.facade, path, seedValue));
    }

    public ZooKeeperSharedCount createSharedCount(String path, int seedCount) {
        return new ZooKeeperSharedCount(new SharedCount(this.facade, path, seedCount));
    }
}

