/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.core.fs.FSDataInputStream;

public class BoundedInputStream
extends InputStream {
    private final FSDataInputStream delegate;
    private long endOffsetExclusive;
    private long position;
    private long mark;

    public BoundedInputStream(FSDataInputStream delegate2, long endOffsetExclusive) throws IOException {
        this.position = delegate2.getPos();
        this.mark = -1L;
        this.endOffsetExclusive = endOffsetExclusive;
        this.delegate = delegate2;
    }

    @Override
    public int read() throws IOException {
        if (this.endOffsetExclusive >= 0L && this.position >= this.endOffsetExclusive) {
            return -1;
        }
        int result = this.delegate.read();
        ++this.position;
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.endOffsetExclusive >= 0L && this.position >= this.endOffsetExclusive) {
            return -1;
        }
        long maxRead = this.endOffsetExclusive >= 0L ? Math.min((long)len, this.endOffsetExclusive - this.position) : (long)len;
        int bytesRead = this.delegate.read(b, off, (int)maxRead);
        if (bytesRead == -1) {
            return -1;
        }
        this.position += (long)bytesRead;
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long toSkip = this.endOffsetExclusive >= 0L ? Math.min(n, this.endOffsetExclusive - this.position) : n;
        long skippedBytes = this.delegate.skip(toSkip);
        this.position += skippedBytes;
        return skippedBytes;
    }

    @Override
    public int available() throws IOException {
        return this.endOffsetExclusive >= 0L && this.position >= this.endOffsetExclusive ? 0 : this.delegate.available();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.delegate.reset();
        this.position = this.mark;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.delegate.mark(readlimit);
        this.mark = this.position;
    }

    public long getEndOffsetExclusive() {
        return this.endOffsetExclusive;
    }

    public void setEndOffsetExclusive(long endOffsetExclusive) {
        this.endOffsetExclusive = endOffsetExclusive;
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }
}

