/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.SchedulingResultPartition;
import org.apache.flink.util.Preconditions;

class DefaultSchedulingResultPartition
implements SchedulingResultPartition {
    private final IntermediateResultPartitionID resultPartitionId;
    private final IntermediateDataSetID intermediateDataSetId;
    private final ResultPartitionType partitionType;
    private SchedulingExecutionVertex producer;
    private final List<SchedulingExecutionVertex> consumers;

    DefaultSchedulingResultPartition(IntermediateResultPartitionID partitionId, IntermediateDataSetID intermediateDataSetId, ResultPartitionType partitionType) {
        this.resultPartitionId = (IntermediateResultPartitionID)((Object)Preconditions.checkNotNull((Object)((Object)partitionId)));
        this.intermediateDataSetId = (IntermediateDataSetID)((Object)Preconditions.checkNotNull((Object)((Object)intermediateDataSetId)));
        this.partitionType = (ResultPartitionType)((Object)Preconditions.checkNotNull((Object)((Object)partitionType)));
        this.consumers = new ArrayList<SchedulingExecutionVertex>();
    }

    @Override
    public IntermediateResultPartitionID getId() {
        return this.resultPartitionId;
    }

    @Override
    public IntermediateDataSetID getResultId() {
        return this.intermediateDataSetId;
    }

    @Override
    public ResultPartitionType getPartitionType() {
        return this.partitionType;
    }

    @Override
    public SchedulingResultPartition.ResultPartitionState getState() {
        switch (this.producer.getState()) {
            case RUNNING: {
                return SchedulingResultPartition.ResultPartitionState.PRODUCING;
            }
            case FINISHED: {
                return SchedulingResultPartition.ResultPartitionState.DONE;
            }
        }
        return SchedulingResultPartition.ResultPartitionState.EMPTY;
    }

    @Override
    public SchedulingExecutionVertex getProducer() {
        return this.producer;
    }

    @Override
    public Collection<SchedulingExecutionVertex> getConsumers() {
        return Collections.unmodifiableCollection(this.consumers);
    }

    void addConsumer(SchedulingExecutionVertex vertex) {
        this.consumers.add((SchedulingExecutionVertex)Preconditions.checkNotNull((Object)vertex));
    }

    void setProducer(SchedulingExecutionVertex vertex) {
        this.producer = (SchedulingExecutionVertex)Preconditions.checkNotNull((Object)vertex);
    }
}

