/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.ScheduledFutureAdapter;
import org.apache.flink.runtime.rpc.MainThreadExecutable;
import org.apache.flink.runtime.rpc.MainThreadValidatorUtil;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcServer;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcEndpoint
implements RpcGateway,
AutoCloseableAsync {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RpcService rpcService;
    private final String endpointId;
    protected final RpcServer rpcServer;
    final AtomicReference<Thread> currentMainThread = new AtomicReference<Object>(null);
    private final MainThreadExecutor mainThreadExecutor;

    protected RpcEndpoint(RpcService rpcService, String endpointId) {
        this.rpcService = (RpcService)Preconditions.checkNotNull((Object)rpcService, (String)"rpcService");
        this.endpointId = (String)Preconditions.checkNotNull((Object)endpointId, (String)"endpointId");
        this.rpcServer = rpcService.startServer(this);
        this.mainThreadExecutor = new MainThreadExecutor(this.rpcServer, this::validateRunsInMainThread);
    }

    protected RpcEndpoint(RpcService rpcService) {
        this(rpcService, UUID.randomUUID().toString());
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public final void start() {
        this.rpcServer.start();
    }

    public void onStart() throws Exception {
    }

    protected final void stop() {
        this.rpcServer.stop();
    }

    public CompletableFuture<Void> onStop() {
        return CompletableFuture.completedFuture(null);
    }

    public final CompletableFuture<Void> closeAsync() {
        this.rpcService.stopServer(this.rpcServer);
        return this.getTerminationFuture();
    }

    public <C extends RpcGateway> C getSelfGateway(Class<C> selfGatewayType) {
        if (selfGatewayType.isInstance(this.rpcServer)) {
            RpcServer selfGateway = this.rpcServer;
            return (C)selfGateway;
        }
        throw new RuntimeException("RpcEndpoint does not implement the RpcGateway interface of type " + selfGatewayType + '.');
    }

    @Override
    public String getAddress() {
        return this.rpcServer.getAddress();
    }

    @Override
    public String getHostname() {
        return this.rpcServer.getHostname();
    }

    protected MainThreadExecutor getMainThreadExecutor() {
        return this.mainThreadExecutor;
    }

    public RpcService getRpcService() {
        return this.rpcService;
    }

    public CompletableFuture<Void> getTerminationFuture() {
        return this.rpcServer.getTerminationFuture();
    }

    protected void runAsync(Runnable runnable) {
        this.rpcServer.runAsync(runnable);
    }

    protected void scheduleRunAsync(Runnable runnable, Time delay) {
        this.scheduleRunAsync(runnable, delay.getSize(), delay.getUnit());
    }

    protected void scheduleRunAsync(Runnable runnable, long delay, TimeUnit unit) {
        this.rpcServer.scheduleRunAsync(runnable, unit.toMillis(delay));
    }

    protected <V> CompletableFuture<V> callAsync(Callable<V> callable, Time timeout) {
        return this.rpcServer.callAsync(callable, timeout);
    }

    public void validateRunsInMainThread() {
        assert (MainThreadValidatorUtil.isRunningInExpectedThread(this.currentMainThread.get()));
    }

    protected static class MainThreadExecutor
    implements ComponentMainThreadExecutor {
        private final MainThreadExecutable gateway;
        private final Runnable mainThreadCheck;

        MainThreadExecutor(MainThreadExecutable gateway, Runnable mainThreadCheck) {
            this.gateway = (MainThreadExecutable)Preconditions.checkNotNull((Object)gateway);
            this.mainThreadCheck = (Runnable)Preconditions.checkNotNull((Object)mainThreadCheck);
        }

        public void runAsync(Runnable runnable) {
            this.gateway.runAsync(runnable);
        }

        public void scheduleRunAsync(Runnable runnable, long delayMillis) {
            this.gateway.scheduleRunAsync(runnable, delayMillis);
        }

        @Override
        public void execute(@Nonnull Runnable command) {
            this.runAsync(command);
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            long delayMillis = TimeUnit.MILLISECONDS.convert(delay, unit);
            FutureTask<Object> ft = new FutureTask<Object>(command, null);
            this.scheduleRunAsync(ft, delayMillis);
            return new ScheduledFutureAdapter<Object>(ft, delayMillis, TimeUnit.MILLISECONDS);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            throw new UnsupportedOperationException("Not implemented because the method is currently not required.");
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            throw new UnsupportedOperationException("Not implemented because the method is currently not required.");
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            throw new UnsupportedOperationException("Not implemented because the method is currently not required.");
        }

        @Override
        public void assertRunningInMainThread() {
            this.mainThreadCheck.run();
        }
    }
}

