/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

interface DoubleAccumulator {
    public void add(double var1);

    public double getValue();

    public String getName();

    public static final class DoubleAverage
    implements DoubleAccumulator {
        public static final String NAME = "avg";
        private double sum;
        private int count;

        private DoubleAverage(double init2) {
            this.sum = init2;
            this.count = 1;
        }

        @Override
        public void add(double value) {
            this.sum += value;
            ++this.count;
        }

        @Override
        public double getValue() {
            return this.sum / (double)this.count;
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static final class DoubleSum
    implements DoubleAccumulator {
        public static final String NAME = "sum";
        private double value;

        private DoubleSum(double init2) {
            this.value = init2;
        }

        @Override
        public void add(double value) {
            this.value += value;
        }

        @Override
        public double getValue() {
            return this.value;
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static final class DoubleMinimum
    implements DoubleAccumulator {
        public static final String NAME = "min";
        private double value;

        private DoubleMinimum(double init2) {
            this.value = init2;
        }

        @Override
        public void add(double value) {
            this.value = Math.min(this.value, value);
        }

        @Override
        public double getValue() {
            return this.value;
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static final class DoubleMaximum
    implements DoubleAccumulator {
        public static final String NAME = "max";
        private double value;

        private DoubleMaximum(double init2) {
            this.value = init2;
        }

        @Override
        public void add(double value) {
            this.value = Math.max(this.value, value);
        }

        @Override
        public double getValue() {
            return this.value;
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static final class DoubleAverageFactory
    implements DoubleAccumulatorFactory<DoubleAverage> {
        private static final DoubleAverageFactory INSTANCE = new DoubleAverageFactory();

        private DoubleAverageFactory() {
        }

        @Override
        public DoubleAverage get(double init2) {
            return new DoubleAverage(init2);
        }

        public static DoubleAverageFactory get() {
            return INSTANCE;
        }
    }

    public static final class DoubleSumFactory
    implements DoubleAccumulatorFactory<DoubleSum> {
        private static final DoubleSumFactory INSTANCE = new DoubleSumFactory();

        private DoubleSumFactory() {
        }

        @Override
        public DoubleSum get(double init2) {
            return new DoubleSum(init2);
        }

        public static DoubleSumFactory get() {
            return INSTANCE;
        }
    }

    public static final class DoubleMinimumFactory
    implements DoubleAccumulatorFactory<DoubleMinimum> {
        private static final DoubleMinimumFactory INSTANCE = new DoubleMinimumFactory();

        private DoubleMinimumFactory() {
        }

        @Override
        public DoubleMinimum get(double init2) {
            return new DoubleMinimum(init2);
        }

        public static DoubleMinimumFactory get() {
            return INSTANCE;
        }
    }

    public static final class DoubleMaximumFactory
    implements DoubleAccumulatorFactory<DoubleMaximum> {
        private static final DoubleMaximumFactory INSTANCE = new DoubleMaximumFactory();

        private DoubleMaximumFactory() {
        }

        @Override
        public DoubleMaximum get(double init2) {
            return new DoubleMaximum(init2);
        }

        public static DoubleMaximumFactory get() {
            return INSTANCE;
        }
    }

    public static interface DoubleAccumulatorFactory<A extends DoubleAccumulator> {
        public A get(double var1);
    }
}

