/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotContext;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlotActions;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.SharedSlotOversubscribedException;
import org.apache.flink.runtime.jobmaster.slotpool.SingleLogicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotSharingManager {
    private static final Logger LOG = LoggerFactory.getLogger(SlotSharingManager.class);
    private final SlotSharingGroupId slotSharingGroupId;
    private final AllocatedSlotActions allocatedSlotActions;
    private final SlotOwner slotOwner;
    private final Map<SlotRequestId, TaskSlot> allTaskSlots;
    private final Map<SlotRequestId, MultiTaskSlot> unresolvedRootSlots;
    private final Map<TaskManagerLocation, Map<AllocationID, MultiTaskSlot>> resolvedRootSlots;

    SlotSharingManager(SlotSharingGroupId slotSharingGroupId, AllocatedSlotActions allocatedSlotActions, SlotOwner slotOwner) {
        this.slotSharingGroupId = (SlotSharingGroupId)((Object)Preconditions.checkNotNull((Object)((Object)slotSharingGroupId)));
        this.allocatedSlotActions = (AllocatedSlotActions)Preconditions.checkNotNull((Object)allocatedSlotActions);
        this.slotOwner = (SlotOwner)Preconditions.checkNotNull((Object)slotOwner);
        this.allTaskSlots = new HashMap<SlotRequestId, TaskSlot>(16);
        this.unresolvedRootSlots = new HashMap<SlotRequestId, MultiTaskSlot>(16);
        this.resolvedRootSlots = new HashMap<TaskManagerLocation, Map<AllocationID, MultiTaskSlot>>(16);
    }

    public boolean isEmpty() {
        return this.allTaskSlots.isEmpty();
    }

    public boolean contains(SlotRequestId slotRequestId) {
        return this.allTaskSlots.containsKey((Object)slotRequestId);
    }

    @Nullable
    TaskSlot getTaskSlot(SlotRequestId slotRequestId) {
        return this.allTaskSlots.get((Object)slotRequestId);
    }

    @Nonnull
    MultiTaskSlot createRootSlot(SlotRequestId slotRequestId, CompletableFuture<? extends SlotContext> slotContextFuture, SlotRequestId allocatedSlotRequestId) {
        MultiTaskSlot rootMultiTaskSlot = new MultiTaskSlot(slotRequestId, slotContextFuture, allocatedSlotRequestId);
        LOG.debug("Create multi task slot [{}] in slot [{}].", (Object)slotRequestId, (Object)allocatedSlotRequestId);
        this.allTaskSlots.put(slotRequestId, rootMultiTaskSlot);
        this.unresolvedRootSlots.put(slotRequestId, rootMultiTaskSlot);
        slotContextFuture.whenComplete((slotContext, throwable) -> {
            if (slotContext != null) {
                MultiTaskSlot resolvedRootNode = this.unresolvedRootSlots.remove((Object)slotRequestId);
                if (resolvedRootNode != null) {
                    AllocationID allocationId = slotContext.getAllocationId();
                    LOG.trace("Fulfill multi task slot [{}] with slot [{}].", (Object)slotRequestId, (Object)allocationId);
                    Map innerMap = this.resolvedRootSlots.computeIfAbsent(slotContext.getTaskManagerLocation(), taskManagerLocation -> new HashMap(4));
                    MultiTaskSlot previousValue = innerMap.put(allocationId, resolvedRootNode);
                    Preconditions.checkState((previousValue == null ? 1 : 0) != 0);
                }
            } else {
                rootMultiTaskSlot.release((Throwable)throwable);
            }
        });
        return rootMultiTaskSlot;
    }

    @Nonnull
    public Collection<SlotSelectionStrategy.SlotInfoAndResources> listResolvedRootSlotInfo(@Nullable AbstractID groupId) {
        return this.resolvedRootSlots.values().stream().flatMap(map -> map.values().stream()).filter(this.validMultiTaskSlotAndDoesNotContain(groupId)).map(multiTaskSlot -> {
            SlotInfo slotInfo = multiTaskSlot.getSlotContextFuture().join();
            return new SlotSelectionStrategy.SlotInfoAndResources(slotInfo, slotInfo.getResourceProfile().subtract(multiTaskSlot.getReservedResources()));
        }).collect(Collectors.toList());
    }

    private Predicate<MultiTaskSlot> validMultiTaskSlotAndDoesNotContain(@Nullable AbstractID groupId) {
        return multiTaskSlot -> !multiTaskSlot.contains(groupId) && !multiTaskSlot.isReleasing();
    }

    @Nullable
    public MultiTaskSlot getResolvedRootSlot(@Nonnull SlotInfo slotInfo) {
        Map<AllocationID, MultiTaskSlot> forLocationEntry = this.resolvedRootSlots.get(slotInfo.getTaskManagerLocation());
        return forLocationEntry != null ? forLocationEntry.get((Object)slotInfo.getAllocationId()) : null;
    }

    @Nullable
    MultiTaskSlot getUnresolvedRootSlot(AbstractID groupId) {
        return this.unresolvedRootSlots.values().stream().filter(this.validMultiTaskSlotAndDoesNotContain(groupId)).findFirst().orElse(null);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{\n\tgroupId=").append((Object)this.slotSharingGroupId).append('\n');
        builder.append("\tunresolved=").append(this.unresolvedRootSlots).append('\n');
        builder.append("\tresolved=").append(this.resolvedRootSlots).append('\n');
        builder.append("\tall=").append(this.allTaskSlots).append('\n');
        return builder.append('}').toString();
    }

    @VisibleForTesting
    public Collection<MultiTaskSlot> getResolvedRootSlots() {
        return new ResolvedRootSlotValues();
    }

    @VisibleForTesting
    Collection<MultiTaskSlot> getUnresolvedRootSlots() {
        return this.unresolvedRootSlots.values();
    }

    private static final class ResolvedRootSlotIterator
    implements Iterator<MultiTaskSlot> {
        private final Iterator<Map<AllocationID, MultiTaskSlot>> baseIterator;
        private Iterator<MultiTaskSlot> currentIterator;

        private ResolvedRootSlotIterator(Iterator<Map<AllocationID, MultiTaskSlot>> baseIterator) {
            this.baseIterator = (Iterator)Preconditions.checkNotNull(baseIterator);
            this.currentIterator = baseIterator.hasNext() ? baseIterator.next().values().iterator() : Collections.emptyIterator();
        }

        @Override
        public boolean hasNext() {
            this.progressToNextElement();
            return this.currentIterator.hasNext();
        }

        @Override
        public MultiTaskSlot next() {
            this.progressToNextElement();
            return this.currentIterator.next();
        }

        private void progressToNextElement() {
            while (this.baseIterator.hasNext() && !this.currentIterator.hasNext()) {
                this.currentIterator = this.baseIterator.next().values().iterator();
            }
        }
    }

    private final class ResolvedRootSlotValues
    extends AbstractCollection<MultiTaskSlot> {
        private ResolvedRootSlotValues() {
        }

        @Override
        public Iterator<MultiTaskSlot> iterator() {
            return new ResolvedRootSlotIterator(SlotSharingManager.this.resolvedRootSlots.values().iterator());
        }

        @Override
        public int size() {
            int numberResolvedMultiTaskSlots = 0;
            for (Map multiTaskSlots : SlotSharingManager.this.resolvedRootSlots.values()) {
                numberResolvedMultiTaskSlots += multiTaskSlots.size();
            }
            return numberResolvedMultiTaskSlots;
        }
    }

    public final class SingleTaskSlot
    extends TaskSlot {
        private final MultiTaskSlot parent;
        private final CompletableFuture<SingleLogicalSlot> singleLogicalSlotFuture;
        private final ResourceProfile resourceProfile;

        private SingleTaskSlot(SlotRequestId slotRequestId, ResourceProfile resourceProfile, AbstractID groupId, MultiTaskSlot parent, Locality locality) {
            super(slotRequestId, groupId);
            this.resourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)resourceProfile);
            this.parent = (MultiTaskSlot)Preconditions.checkNotNull((Object)parent);
            Preconditions.checkNotNull((Object)((Object)locality));
            this.singleLogicalSlotFuture = parent.getSlotContextFuture().thenApply(slotContext -> {
                LOG.trace("Fulfill single task slot [{}] with slot [{}].", (Object)slotRequestId, (Object)slotContext.getAllocationId());
                return new SingleLogicalSlot(slotRequestId, (SlotContext)slotContext, SlotSharingManager.this.slotSharingGroupId, locality, SlotSharingManager.this.slotOwner);
            });
        }

        CompletableFuture<LogicalSlot> getLogicalSlotFuture() {
            return this.singleLogicalSlotFuture.thenApply(Function.identity());
        }

        @Override
        public void release(Throwable cause) {
            this.singleLogicalSlotFuture.completeExceptionally(cause);
            if (this.singleLogicalSlotFuture.isDone() && !this.singleLogicalSlotFuture.isCompletedExceptionally()) {
                SingleLogicalSlot singleLogicalSlot = this.singleLogicalSlotFuture.getNow(null);
                singleLogicalSlot.release(cause);
            }
            this.parent.releaseChild(this.getGroupId());
        }

        @Override
        public ResourceProfile getReservedResources() {
            return this.resourceProfile;
        }

        public String toString() {
            String logicalSlotString = "(pending)";
            try {
                LogicalSlot slot = this.singleLogicalSlotFuture.getNow(null);
                if (slot != null) {
                    logicalSlotString = "(requestId=" + (Object)((Object)slot.getSlotRequestId()) + ", allocationId=" + (Object)((Object)slot.getAllocationId()) + ')';
                }
            }
            catch (Exception e) {
                logicalSlotString = '(' + ExceptionUtils.stripCompletionException((Throwable)e).getMessage() + ')';
            }
            return "SingleTaskSlot{logicalSlot=" + logicalSlotString + ", request=" + (Object)((Object)this.getSlotRequestId()) + ", group=" + this.getGroupId() + '}';
        }
    }

    public final class MultiTaskSlot
    extends TaskSlot
    implements PhysicalSlot.Payload {
        private final Map<AbstractID, TaskSlot> children;
        @Nullable
        private final MultiTaskSlot parent;
        private final CompletableFuture<? extends SlotContext> slotContextFuture;
        @Nullable
        private final SlotRequestId allocatedSlotRequestId;
        private boolean releasingChildren;
        private ResourceProfile reservedResources;

        private MultiTaskSlot(SlotRequestId slotRequestId, AbstractID groupId, MultiTaskSlot parent) {
            this(slotRequestId, groupId, (MultiTaskSlot)Preconditions.checkNotNull((Object)parent), parent.getSlotContextFuture(), null);
        }

        private MultiTaskSlot(SlotRequestId slotRequestId, CompletableFuture<? extends SlotContext> slotContextFuture, SlotRequestId allocatedSlotRequestId) {
            this(slotRequestId, null, null, slotContextFuture, allocatedSlotRequestId);
        }

        private MultiTaskSlot(@Nullable SlotRequestId slotRequestId, @Nullable AbstractID groupId, MultiTaskSlot parent, @Nullable CompletableFuture<? extends SlotContext> slotContextFuture, SlotRequestId allocatedSlotRequestId) {
            super(slotRequestId, groupId);
            Preconditions.checkNotNull(slotContextFuture);
            this.parent = parent;
            this.allocatedSlotRequestId = allocatedSlotRequestId;
            this.children = new HashMap<AbstractID, TaskSlot>(16);
            this.releasingChildren = false;
            this.reservedResources = ResourceProfile.ZERO;
            this.slotContextFuture = slotContextFuture.handle((slotContext, throwable) -> {
                if (throwable != null) {
                    this.release((Throwable)throwable);
                    throw new CompletionException((Throwable)throwable);
                }
                if (parent == null) {
                    this.checkOversubscriptionAndReleaseChildren((SlotContext)slotContext);
                }
                return slotContext;
            });
        }

        CompletableFuture<? extends SlotContext> getSlotContextFuture() {
            return this.slotContextFuture;
        }

        MultiTaskSlot allocateMultiTaskSlot(SlotRequestId slotRequestId, AbstractID groupId) {
            Preconditions.checkState((!super.contains(groupId) ? 1 : 0) != 0);
            LOG.debug("Create nested multi task slot [{}] in parent multi task slot [{}] for group [{}].", new Object[]{slotRequestId, this.getSlotRequestId(), groupId});
            MultiTaskSlot inner = new MultiTaskSlot(slotRequestId, groupId, this);
            this.children.put(groupId, inner);
            SlotSharingManager.this.allTaskSlots.put(slotRequestId, inner);
            return inner;
        }

        SingleTaskSlot allocateSingleTaskSlot(SlotRequestId slotRequestId, ResourceProfile resourceProfile, AbstractID groupId, Locality locality) {
            Preconditions.checkState((!super.contains(groupId) ? 1 : 0) != 0);
            LOG.debug("Create single task slot [{}] in multi task slot [{}] for group {}.", new Object[]{slotRequestId, this.getSlotRequestId(), groupId});
            SingleTaskSlot leaf = new SingleTaskSlot(slotRequestId, resourceProfile, groupId, this, locality);
            this.children.put(groupId, leaf);
            SlotSharingManager.this.allTaskSlots.put(slotRequestId, leaf);
            this.reserveResource(resourceProfile);
            return leaf;
        }

        @Override
        public boolean contains(AbstractID groupId) {
            if (super.contains(groupId)) {
                return true;
            }
            for (TaskSlot taskSlot : this.children.values()) {
                if (!taskSlot.contains(groupId)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void release(Throwable cause) {
            this.releasingChildren = true;
            for (TaskSlot taskSlot : this.children.values()) {
                taskSlot.release(cause);
                SlotSharingManager.this.allTaskSlots.remove((Object)taskSlot.getSlotRequestId());
            }
            this.children.clear();
            this.releasingChildren = false;
            if (this.parent != null) {
                this.parent.releaseChild(this.getGroupId());
            } else if (SlotSharingManager.this.allTaskSlots.remove((Object)this.getSlotRequestId()) != null) {
                Map multiTaskSlots;
                SlotContext slotContext;
                MultiTaskSlot unresolvedRootSlot = (MultiTaskSlot)SlotSharingManager.this.unresolvedRootSlots.remove((Object)this.getSlotRequestId());
                if (unresolvedRootSlot == null && (slotContext = (SlotContext)this.slotContextFuture.getNow(null)) != null && (multiTaskSlots = (Map)SlotSharingManager.this.resolvedRootSlots.get(slotContext.getTaskManagerLocation())) != null) {
                    MultiTaskSlot removedSlot = (MultiTaskSlot)multiTaskSlots.remove((Object)slotContext.getAllocationId());
                    Preconditions.checkState((removedSlot == this ? 1 : 0) != 0);
                    if (multiTaskSlots.isEmpty()) {
                        SlotSharingManager.this.resolvedRootSlots.remove(slotContext.getTaskManagerLocation());
                    }
                }
                SlotSharingManager.this.allocatedSlotActions.releaseSlot(this.allocatedSlotRequestId, cause);
            }
        }

        @Override
        public ResourceProfile getReservedResources() {
            return this.reservedResources;
        }

        boolean mayHaveEnoughResourcesToFulfill(ResourceProfile resourceProfile) {
            if (!this.slotContextFuture.isDone()) {
                return true;
            }
            MultiTaskSlot root = this;
            while (root.parent != null) {
                root = root.parent;
            }
            SlotContext slotContext = root.getSlotContextFuture().join();
            return slotContext.getResourceProfile().isMatching(resourceProfile.merge(root.getReservedResources()));
        }

        private void releaseChild(AbstractID childGroupId) {
            if (!this.releasingChildren) {
                TaskSlot child = this.children.remove(childGroupId);
                if (child != null) {
                    SlotSharingManager.this.allTaskSlots.remove((Object)child.getSlotRequestId());
                    this.releaseResource(child.getReservedResources());
                }
                if (this.children.isEmpty()) {
                    this.release(new FlinkException("Release multi task slot because all children have been released."));
                }
            }
        }

        private void reserveResource(ResourceProfile resourceProfile) {
            this.reservedResources = this.reservedResources.merge(resourceProfile);
            if (this.parent != null) {
                this.parent.reserveResource(resourceProfile);
            }
        }

        private void releaseResource(ResourceProfile resourceProfile) {
            this.reservedResources = this.reservedResources.subtract(resourceProfile);
            if (this.parent != null) {
                this.parent.releaseResource(resourceProfile);
            }
        }

        private void checkOversubscriptionAndReleaseChildren(SlotContext slotContext) {
            ResourceProfile slotResources = slotContext.getResourceProfile();
            ArrayList<TaskSlot> childrenToEvict = new ArrayList<TaskSlot>();
            ResourceProfile requiredResources = ResourceProfile.ZERO;
            for (TaskSlot slot : this.children.values()) {
                ResourceProfile resourcesWithChild = requiredResources.merge(slot.getReservedResources());
                if (slotResources.isMatching(resourcesWithChild)) {
                    requiredResources = resourcesWithChild;
                    continue;
                }
                childrenToEvict.add(slot);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not all requests are fulfilled due to over-allocated, number of requests is {}, number of evicted requests is {}, underlying allocated is {}, fulfilled is {}, evicted requests is {},", new Object[]{this.children.size(), childrenToEvict.size(), slotContext.getResourceProfile(), requiredResources, childrenToEvict});
            }
            if (childrenToEvict.size() == this.children.size()) {
                this.release(new SharedSlotOversubscribedException("The allocated slot does not have enough resource for any task.", false));
            } else {
                for (TaskSlot taskSlot : childrenToEvict) {
                    taskSlot.release(new SharedSlotOversubscribedException("The allocated slot does not have enough resource for all the tasks.", true));
                }
            }
        }

        boolean isReleasing() {
            return this.releasingChildren;
        }

        public String toString() {
            String physicalSlotDescription;
            try {
                physicalSlotDescription = String.valueOf(this.slotContextFuture.getNow(null));
            }
            catch (Exception e) {
                physicalSlotDescription = '(' + ExceptionUtils.stripCompletionException((Throwable)e).getMessage() + ')';
            }
            return "MultiTaskSlot{requestId=" + (Object)((Object)this.getSlotRequestId()) + ", allocatedRequestId=" + (Object)((Object)this.allocatedSlotRequestId) + ", groupId=" + this.getGroupId() + ", physicalSlot=" + physicalSlotDescription + ", children=" + this.children.values().toString() + '}';
        }
    }

    public static abstract class TaskSlot {
        private final SlotRequestId slotRequestId;
        @Nullable
        private final AbstractID groupId;

        TaskSlot(SlotRequestId slotRequestId, @Nullable AbstractID groupId) {
            this.slotRequestId = (SlotRequestId)((Object)Preconditions.checkNotNull((Object)((Object)slotRequestId)));
            this.groupId = groupId;
        }

        public SlotRequestId getSlotRequestId() {
            return this.slotRequestId;
        }

        @Nullable
        public AbstractID getGroupId() {
            return this.groupId;
        }

        public boolean contains(AbstractID groupId) {
            return Objects.equals(this.groupId, groupId);
        }

        public abstract void release(Throwable var1);

        public abstract ResourceProfile getReservedResources();
    }

    static final class MultiTaskSlotLocality {
        private final MultiTaskSlot multiTaskSlot;
        private final Locality locality;

        MultiTaskSlotLocality(MultiTaskSlot multiTaskSlot, Locality locality) {
            this.multiTaskSlot = (MultiTaskSlot)Preconditions.checkNotNull((Object)multiTaskSlot);
            this.locality = (Locality)((Object)Preconditions.checkNotNull((Object)((Object)locality)));
        }

        MultiTaskSlot getMultiTaskSlot() {
            return this.multiTaskSlot;
        }

        public Locality getLocality() {
            return this.locality;
        }

        public static MultiTaskSlotLocality of(MultiTaskSlot multiTaskSlot, Locality locality) {
            return new MultiTaskSlotLocality(multiTaskSlot, locality);
        }
    }
}

