/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.instance.SharedSlot;
import org.apache.flink.runtime.instance.SimpleSlotContext;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.SlotContext;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

public abstract class Slot {
    private static final AtomicIntegerFieldUpdater<Slot> STATUS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Slot.class, "status");
    private static final int ALLOCATED_AND_ALIVE = 0;
    private static final int CANCELLED = 1;
    private static final int RELEASED = 2;
    protected static final AllocationID NO_ALLOCATION_ID = new AllocationID(0L, 0L);
    protected static final SlotRequestId NO_SLOT_REQUEST_ID = new SlotRequestId(0L, 0L);
    protected static final SlotSharingGroupId NO_SLOT_SHARING_GROUP_ID = new SlotSharingGroupId(0L, 0L);
    private final SlotContext slotContext;
    private final SlotOwner owner;
    @Nullable
    private final SharedSlot parent;
    @Nullable
    private final AbstractID groupID;
    private final int slotNumber;
    private volatile int status = 0;

    protected Slot(SlotOwner owner, TaskManagerLocation location, int slotNumber, TaskManagerGateway taskManagerGateway, @Nullable SharedSlot parent, @Nullable AbstractID groupID) {
        Preconditions.checkArgument((slotNumber >= 0 ? 1 : 0) != 0);
        this.slotContext = new SimpleSlotContext(NO_ALLOCATION_ID, location, slotNumber, taskManagerGateway);
        this.owner = (SlotOwner)Preconditions.checkNotNull((Object)owner);
        this.parent = parent;
        this.groupID = groupID;
        this.slotNumber = slotNumber;
    }

    protected Slot(SlotContext slotContext, SlotOwner owner, int slotNumber, @Nullable SharedSlot parent, @Nullable AbstractID groupID) {
        this.slotContext = (SlotContext)Preconditions.checkNotNull((Object)slotContext);
        this.owner = (SlotOwner)Preconditions.checkNotNull((Object)owner);
        this.parent = parent;
        this.groupID = groupID;
        this.slotNumber = slotNumber;
    }

    public SlotContext getSlotContext() {
        return this.slotContext;
    }

    public ResourceID getTaskManagerID() {
        return this.slotContext.getTaskManagerLocation().getResourceID();
    }

    public TaskManagerLocation getTaskManagerLocation() {
        return this.slotContext.getTaskManagerLocation();
    }

    public TaskManagerGateway getTaskManagerGateway() {
        return this.slotContext.getTaskManagerGateway();
    }

    public SlotOwner getOwner() {
        return this.owner;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public int getRootSlotNumber() {
        if (this.parent == null) {
            return this.slotNumber;
        }
        return this.parent.getRootSlotNumber();
    }

    @Nullable
    public AbstractID getGroupID() {
        return this.groupID;
    }

    @Nullable
    public SharedSlot getParent() {
        return this.parent;
    }

    public Slot getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public abstract int getNumberLeaves();

    public boolean isAlive() {
        return this.status == 0;
    }

    public boolean isCanceled() {
        return this.status != 0;
    }

    public boolean isReleased() {
        return this.status == 2;
    }

    final boolean markCancelled() {
        return STATUS_UPDATER.compareAndSet(this, 0, 1);
    }

    final boolean markReleased() {
        return STATUS_UPDATER.compareAndSet(this, 1, 2);
    }

    public abstract CompletableFuture<?> releaseSlot(@Nullable Throwable var1);

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public String toString() {
        return this.hierarchy() + " - " + this.getTaskManagerLocation() + " - " + Slot.getStateName(this.status);
    }

    protected String hierarchy() {
        return (this.getParent() != null ? this.getParent().hierarchy() : "") + '(' + this.getSlotNumber() + ')';
    }

    private static String getStateName(int state) {
        switch (state) {
            case 0: {
                return "ALLOCATED/ALIVE";
            }
            case 1: {
                return "CANCELLED";
            }
            case 2: {
                return "RELEASED";
            }
        }
        return "(unknown)";
    }
}

