/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.CompositeStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.util.Preconditions;

public class OperatorState
implements CompositeStateHandle {
    private static final long serialVersionUID = -4845578005863201810L;
    private final OperatorID operatorID;
    private final Map<Integer, OperatorSubtaskState> operatorSubtaskStates;
    private final int parallelism;
    private final int maxParallelism;

    public OperatorState(OperatorID operatorID, int parallelism, int maxParallelism) {
        Preconditions.checkArgument((parallelism <= maxParallelism ? 1 : 0) != 0, (Object)("Parallelism " + parallelism + " is not smaller or equal to max parallelism " + maxParallelism + "."));
        this.operatorID = operatorID;
        this.operatorSubtaskStates = new HashMap<Integer, OperatorSubtaskState>(parallelism);
        this.parallelism = parallelism;
        this.maxParallelism = maxParallelism;
    }

    public OperatorID getOperatorID() {
        return this.operatorID;
    }

    public void putState(int subtaskIndex, OperatorSubtaskState subtaskState) {
        Preconditions.checkNotNull((Object)subtaskState);
        if (subtaskIndex < 0 || subtaskIndex >= this.parallelism) {
            throw new IndexOutOfBoundsException("The given sub task index " + subtaskIndex + " exceeds the maximum number of sub tasks " + this.operatorSubtaskStates.size());
        }
        this.operatorSubtaskStates.put(subtaskIndex, subtaskState);
    }

    public OperatorSubtaskState getState(int subtaskIndex) {
        if (subtaskIndex < 0 || subtaskIndex >= this.parallelism) {
            throw new IndexOutOfBoundsException("The given sub task index " + subtaskIndex + " exceeds the maximum number of sub tasks " + this.operatorSubtaskStates.size());
        }
        return this.operatorSubtaskStates.get(subtaskIndex);
    }

    public Collection<OperatorSubtaskState> getStates() {
        return this.operatorSubtaskStates.values();
    }

    public int getNumberCollectedStates() {
        return this.operatorSubtaskStates.size();
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    @Override
    public void discardState() throws Exception {
        for (OperatorSubtaskState operatorSubtaskState : this.operatorSubtaskStates.values()) {
            operatorSubtaskState.discardState();
        }
    }

    @Override
    public void registerSharedStates(SharedStateRegistry sharedStateRegistry) {
        for (OperatorSubtaskState operatorSubtaskState : this.operatorSubtaskStates.values()) {
            operatorSubtaskState.registerSharedStates(sharedStateRegistry);
        }
    }

    @Override
    public long getStateSize() {
        long result = 0L;
        for (int i = 0; i < this.parallelism; ++i) {
            OperatorSubtaskState operatorSubtaskState = this.operatorSubtaskStates.get(i);
            if (operatorSubtaskState == null) continue;
            result += operatorSubtaskState.getStateSize();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OperatorState) {
            OperatorState other = (OperatorState)obj;
            return this.operatorID.equals((Object)other.operatorID) && this.parallelism == other.parallelism && this.operatorSubtaskStates.equals(other.operatorSubtaskStates);
        }
        return false;
    }

    public int hashCode() {
        return this.parallelism + 31 * Objects.hash(new Object[]{this.operatorID, this.operatorSubtaskStates});
    }

    public Map<Integer, OperatorSubtaskState> getSubtaskStates() {
        return Collections.unmodifiableMap(this.operatorSubtaskStates);
    }

    public String toString() {
        return "OperatorState(operatorID: " + (Object)((Object)this.operatorID) + ", parallelism: " + this.parallelism + ", maxParallelism: " + this.maxParallelism + ", sub task states: " + this.operatorSubtaskStates.size() + ", total size (bytes): " + this.getStateSize() + ')';
    }
}

