/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.List;
import java.util.ListIterator;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CompletedCheckpointStore {
    public static final Logger LOG = LoggerFactory.getLogger(CompletedCheckpointStore.class);

    public void recover() throws Exception;

    public void addCheckpoint(CompletedCheckpoint var1) throws Exception;

    default public CompletedCheckpoint getLatestCheckpoint(boolean isPreferCheckpointForRecovery) throws Exception {
        if (this.getAllCheckpoints().isEmpty()) {
            return null;
        }
        CompletedCheckpoint candidate = this.getAllCheckpoints().get(this.getAllCheckpoints().size() - 1);
        if (isPreferCheckpointForRecovery && this.getAllCheckpoints().size() > 1) {
            try {
                List<CompletedCheckpoint> allCheckpoints = this.getAllCheckpoints();
                ListIterator<CompletedCheckpoint> listIterator = allCheckpoints.listIterator(allCheckpoints.size() - 1);
                while (listIterator.hasPrevious()) {
                    CompletedCheckpoint prev = listIterator.previous();
                    if (prev.getProperties().isSavepoint()) continue;
                    candidate = prev;
                    LOG.info("Found a completed checkpoint before the latest savepoint, will use it to recover!");
                    break;
                }
            }
            catch (Exception e) {
                LOG.error("Method getAllCheckpoints caused exception : ", (Throwable)e);
                throw new FlinkRuntimeException((Throwable)e);
            }
        }
        return candidate;
    }

    public void shutdown(JobStatus var1) throws Exception;

    public List<CompletedCheckpoint> getAllCheckpoints() throws Exception;

    public int getNumberOfRetainedCheckpoints();

    public int getMaxNumberOfRetainedCheckpoints();

    public boolean requiresExternalizedCheckpoints();
}

