/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery;

import akka.io.DirectByteBufferPool$;
import akka.remote.artery.ArteryTransport$;
import akka.remote.artery.EnvelopeBuffer$;
import akka.remote.artery.HeaderBuilder;
import akka.remote.artery.HeaderBuilderImpl;
import akka.remote.artery.OutboundEnvelope;
import akka.remote.artery.RemoteInstruments;
import akka.util.OptionVal$;
import akka.util.Unsafe;
import java.nio.ByteBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005MvAB\u0001\u0003\u0011\u0003!\u0001\"\u0001\bF]Z,Gn\u001c9f\u0005V4g-\u001a:\u000b\u0005\r!\u0011AB1si\u0016\u0014\u0018P\u0003\u0002\u0006\r\u00051!/Z7pi\u0016T\u0011aB\u0001\u0005C.\\\u0017\r\u0005\u0002\n\u00155\t!A\u0002\u0004\f\u0005!\u0005A\u0001\u0004\u0002\u000f\u000b:4X\r\\8qK\n+hMZ3s'\tQQ\u0002\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006))!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t\u0001\u0002C\u0004\u0019\u0015\t\u0007I\u0011A\r\u0002\u0017Q\u000bw\rV=qK6\u000b7o[\u000b\u00025A\u0011abG\u0005\u00039=\u00111!\u00138u\u0011\u0019q\"\u0002)A\u00055\u0005aA+Y4UsB,W*Y:lA!9\u0001E\u0003b\u0001\n\u0003I\u0012\u0001\u0004+bOZ\u000bG.^3NCN\\\u0007B\u0002\u0012\u000bA\u0003%!$A\u0007UC\u001e4\u0016\r\\;f\u001b\u0006\u001c8\u000e\t\u0005\bI)\u0011\r\u0011\"\u0001&\u0003MiU\r^1eCR\f\u0007K]3tK:$h\t\\1h+\u00051\u0003CA\u0005(\u0013\tA#A\u0001\u0005CsR,g\t\\1h\u0011\u0019Q#\u0002)A\u0005M\u0005!R*\u001a;bI\u0006$\u0018\r\u0015:fg\u0016tGO\u00127bO\u0002Bq\u0001\f\u0006C\u0002\u0013\u0005\u0011$A\u0007WKJ\u001c\u0018n\u001c8PM\u001a\u001cX\r\u001e\u0005\u0007])\u0001\u000b\u0011\u0002\u000e\u0002\u001dY+'o]5p]>3gm]3uA!9\u0001G\u0003b\u0001\n\u0003I\u0012a\u0003$mC\u001e\u001cxJ\u001a4tKRDaA\r\u0006!\u0002\u0013Q\u0012\u0001\u0004$mC\u001e\u001cxJ\u001a4tKR\u0004\u0003b\u0002\u001b\u000b\u0005\u0004%\t!G\u0001&\u0003\u000e$xN\u001d*fM\u000e{W\u000e\u001d:fgNLwN\u001c+bE2,g+\u001a:tS>twJ\u001a4tKRDaA\u000e\u0006!\u0002\u0013Q\u0012AJ!di>\u0014(+\u001a4D_6\u0004(/Z:tS>tG+\u00192mKZ+'o]5p]>3gm]3uA!9\u0001H\u0003b\u0001\n\u0003I\u0012AK\"mCN\u001cX*\u00198jM\u0016\u001cHoQ8naJ,7o]5p]R\u000b'\r\\3WKJ\u001c\u0018n\u001c8PM\u001a\u001cX\r\u001e\u0005\u0007u)\u0001\u000b\u0011\u0002\u000e\u0002W\rc\u0017m]:NC:Lg-Z:u\u0007>l\u0007O]3tg&|g\u000eV1cY\u00164VM]:j_:|eMZ:fi\u0002Bq\u0001\u0010\u0006C\u0002\u0013\u0005\u0011$A\u0005VS\u0012|eMZ:fi\"1aH\u0003Q\u0001\ni\t!\"V5e\u001f\u001a47/\u001a;!\u0011\u001d\u0001%B1A\u0005\u0002e\t\u0001cU3sS\u0006d\u0017N_3s\u001f\u001a47/\u001a;\t\r\tS\u0001\u0015!\u0003\u001b\u0003E\u0019VM]5bY&TXM](gMN,G\u000f\t\u0005\b\t*\u0011\r\u0011\"\u0001\u001a\u0003]\u0019VM\u001c3fe\u0006\u001bGo\u001c:SK\u001a$\u0016mZ(gMN,G\u000f\u0003\u0004G\u0015\u0001\u0006IAG\u0001\u0019'\u0016tG-\u001a:BGR|'OU3g)\u0006<wJ\u001a4tKR\u0004\u0003b\u0002%\u000b\u0005\u0004%\t!G\u0001\u001b%\u0016\u001c\u0017\u000e]5f]R\f5\r^8s%\u00164G+Y4PM\u001a\u001cX\r\u001e\u0005\u0007\u0015*\u0001\u000b\u0011\u0002\u000e\u00027I+7-\u001b9jK:$\u0018i\u0019;peJ+g\rV1h\u001f\u001a47/\u001a;!\u0011\u001da%B1A\u0005\u0002e\tac\u00117bgNl\u0015M\\5gKN$H+Y4PM\u001a\u001cX\r\u001e\u0005\u0007\u001d*\u0001\u000b\u0011\u0002\u000e\u0002/\rc\u0017m]:NC:Lg-Z:u)\u0006<wJ\u001a4tKR\u0004\u0003b\u0002)\u000b\u0005\u0004%\t!G\u0001)\u001b\u0016$\u0018\rZ1uC\u000e{g\u000e^1j]\u0016\u0014\u0018I\u001c3MSR,'/\u00197TK\u000e$\u0018n\u001c8PM\u001a\u001cX\r\u001e\u0005\u0007%*\u0001\u000b\u0011\u0002\u000e\u0002S5+G/\u00193bi\u0006\u001cuN\u001c;bS:,'/\u00118e\u0019&$XM]1m'\u0016\u001cG/[8o\u001f\u001a47/\u001a;!\r\u0015Y!A\u0001\u0003U'\t\u0019V\u0002\u0003\u0005W'\n\u0015\r\u0011\"\u0001X\u0003)\u0011\u0017\u0010^3Ck\u001a4WM]\u000b\u00021B\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0004]&|'\"A/\u0002\t)\fg/Y\u0005\u0003?j\u0013!BQ=uK\n+hMZ3s\u0011!\t7K!A!\u0002\u0013A\u0016a\u00032zi\u0016\u0014UO\u001a4fe\u0002BQ\u0001F*\u0005\u0002\r$\"\u0001Z3\u0011\u0005%\u0019\u0006\"\u0002,c\u0001\u0004A\u0006bB4T\u0005\u0004%\t\u0001[\u0001\fC\u0016\u0014xN\u001c\"vM\u001a,'/F\u0001j!\tQ\u0017/D\u0001l\u0015\taW.\u0001\u0006d_:\u001cWO\u001d:f]RT!A\\8\u0002\r\u0005<'o\u001c8b\u0015\u0005\u0001\u0018aA8sO&\u0011!o\u001b\u0002\r+:\u001c\u0018MZ3Ck\u001a4WM\u001d\u0005\u0007iN\u0003\u000b\u0011B5\u0002\u0019\u0005,'o\u001c8Ck\u001a4WM\u001d\u0011\t\u000fY\u001c\u0006\u0019!C\u0005o\u0006aA.\u001b;fe\u0006d7\t[1sgV\t\u0001\u0010E\u0002\u000fsnL!A_\b\u0003\u000b\u0005\u0013(/Y=\u0011\u00059a\u0018BA?\u0010\u0005\u0011\u0019\u0005.\u0019:\t\u0011}\u001c\u0006\u0019!C\u0005\u0003\u0003\t\u0001\u0003\\5uKJ\fGn\u00115beN|F%Z9\u0015\t\u0005\r\u0011\u0011\u0002\t\u0004\u001d\u0005\u0015\u0011bAA\u0004\u001f\t!QK\\5u\u0011!\tYA`A\u0001\u0002\u0004A\u0018a\u0001=%c!9\u0011qB*!B\u0013A\u0018!\u00047ji\u0016\u0014\u0018\r\\\"iCJ\u001c\b\u0005C\u0005\u0002\u0014M\u0003\r\u0011\"\u0003\u0002\u0016\u0005aA.\u001b;fe\u0006d')\u001f;fgV\u0011\u0011q\u0003\t\u0005\u001de\fI\u0002E\u0002\u000f\u00037I1!!\b\u0010\u0005\u0011\u0011\u0015\u0010^3\t\u0013\u0005\u00052\u000b1A\u0005\n\u0005\r\u0012\u0001\u00057ji\u0016\u0014\u0018\r\u001c\"zi\u0016\u001cx\fJ3r)\u0011\t\u0019!!\n\t\u0015\u0005-\u0011qDA\u0001\u0002\u0004\t9\u0002\u0003\u0005\u0002*M\u0003\u000b\u0015BA\f\u00035a\u0017\u000e^3sC2\u0014\u0015\u0010^3tA!A\u0011QF*A\u0002\u0013%\u0011$A\u0005`gR\u0014X-Y7JI\"I\u0011\u0011G*A\u0002\u0013%\u00111G\u0001\u000e?N$(/Z1n\u0013\u0012|F%Z9\u0015\t\u0005\r\u0011Q\u0007\u0005\n\u0003\u0017\ty#!AA\u0002iAq!!\u000fTA\u0003&!$\u0001\u0006`gR\u0014X-Y7JI\u0002Ba!!\u0010T\t\u0003I\u0012\u0001C:ue\u0016\fW.\u00133\t\u000f\u0005\u00053\u000b\"\u0001\u0002D\u0005Y1/\u001a;TiJ,\u0017-\\%e)\u0011\t\u0019!!\u0012\t\u000f\u0005\u001d\u0013q\ba\u00015\u0005Ya.Z<TiJ,\u0017-\\%e\u0011\u001d\tYe\u0015C\u0001\u0003\u001b\n1b\u001e:ji\u0016DU-\u00193feR!\u00111AA(\u0011!\t\t&!\u0013A\u0002\u0005M\u0013!\u00015\u0011\u0007%\t)&C\u0002\u0002X\t\u0011Q\u0002S3bI\u0016\u0014()^5mI\u0016\u0014\bbBA&'\u0012\u0005\u00111\f\u000b\u0007\u0003\u0007\ti&a\u0018\t\u0011\u0005E\u0013\u0011\fa\u0001\u0003'B\u0001\"!\u0019\u0002Z\u0001\u0007\u00111M\u0001\u0003_\u0016\u00042!CA3\u0013\r\t9G\u0001\u0002\u0011\u001fV$(m\\;oI\u0016sg/\u001a7pa\u0016Dq!a\u001bT\t\u0003\ti'A\u0006qCJ\u001cX\rS3bI\u0016\u0014H\u0003BA\u0002\u0003_B\u0001\"!\u0015\u0002j\u0001\u0007\u00111\u000b\u0005\b\u0003g\u001aF\u0011BA;\u0003-)W\u000e\u001d;z\u0003NtU\u000f\u001c7\u0015\t\u0005]\u0014Q\u0011\t\u0005\u0003s\nyHD\u0002\u000f\u0003wJ1!! \u0010\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011QAB\u0005\u0019\u0019FO]5oO*\u0019\u0011QP\b\t\u0011\u0005\u001d\u0015\u0011\u000fa\u0001\u0003o\n\u0011a\u001d\u0005\b\u0003\u0017\u001bF\u0011BAG\u0003-\u0011X-\u00193MSR,'/\u00197\u0015\u0005\u0005]\u0004bBAI'\u0012%\u00111S\u0001\roJLG/\u001a'ji\u0016\u0014\u0018\r\u001c\u000b\u0007\u0003\u0007\t)*!'\t\u000f\u0005]\u0015q\u0012a\u00015\u0005IA/Y4PM\u001a\u001cX\r\u001e\u0005\t\u00037\u000by\t1\u0001\u0002x\u00059A.\u001b;fe\u0006d\u0007bBAP'\u0012%\u0011\u0011U\u0001\u0019K:\u001cXO]3MSR,'/\u00197DQ\u0006\u00148\u000fT3oORDG\u0003BA\u0002\u0003GCq!!*\u0002\u001e\u0002\u0007!$\u0001\u0004mK:<G\u000f\u001b\u0005\b\u0003S\u001bF\u0011AAV\u0003a!(/_\"mK\u0006tG)\u001b:fGR\u0014\u0015\u0010^3Ck\u001a4WM\u001d\u000b\u0003\u0003\u0007Aq!a,T\t\u0003\t\t,\u0001\u0003d_BLH#\u00013")
public final class EnvelopeBuffer {
    private final ByteBuffer byteBuffer;
    private final UnsafeBuffer aeronBuffer;
    private char[] literalChars;
    private byte[] literalBytes;
    private int _streamId;

    public static int MetadataContainerAndLiteralSectionOffset() {
        return EnvelopeBuffer$.MODULE$.MetadataContainerAndLiteralSectionOffset();
    }

    public static int ClassManifestTagOffset() {
        return EnvelopeBuffer$.MODULE$.ClassManifestTagOffset();
    }

    public static int RecipientActorRefTagOffset() {
        return EnvelopeBuffer$.MODULE$.RecipientActorRefTagOffset();
    }

    public static int SenderActorRefTagOffset() {
        return EnvelopeBuffer$.MODULE$.SenderActorRefTagOffset();
    }

    public static int SerializerOffset() {
        return EnvelopeBuffer$.MODULE$.SerializerOffset();
    }

    public static int UidOffset() {
        return EnvelopeBuffer$.MODULE$.UidOffset();
    }

    public static int ClassManifestCompressionTableVersionOffset() {
        return EnvelopeBuffer$.MODULE$.ClassManifestCompressionTableVersionOffset();
    }

    public static int ActorRefCompressionTableVersionOffset() {
        return EnvelopeBuffer$.MODULE$.ActorRefCompressionTableVersionOffset();
    }

    public static int FlagsOffset() {
        return EnvelopeBuffer$.MODULE$.FlagsOffset();
    }

    public static int VersionOffset() {
        return EnvelopeBuffer$.MODULE$.VersionOffset();
    }

    public static byte MetadataPresentFlag() {
        return EnvelopeBuffer$.MODULE$.MetadataPresentFlag();
    }

    public static int TagValueMask() {
        return EnvelopeBuffer$.MODULE$.TagValueMask();
    }

    public static int TagTypeMask() {
        return EnvelopeBuffer$.MODULE$.TagTypeMask();
    }

    public ByteBuffer byteBuffer() {
        return this.byteBuffer;
    }

    public UnsafeBuffer aeronBuffer() {
        return this.aeronBuffer;
    }

    private char[] literalChars() {
        return this.literalChars;
    }

    private void literalChars_$eq(char[] x$1) {
        this.literalChars = x$1;
    }

    private byte[] literalBytes() {
        return this.literalBytes;
    }

    private void literalBytes_$eq(byte[] x$1) {
        this.literalBytes = x$1;
    }

    private int _streamId() {
        return this._streamId;
    }

    private void _streamId_$eq(int x$1) {
        this._streamId = x$1;
    }

    public int streamId() {
        if (this._streamId() != -1) {
            return this._streamId();
        }
        throw new IllegalStateException("StreamId was not set");
    }

    public void setStreamId(int newStreamId) {
        this._streamId_$eq(newStreamId);
    }

    public void writeHeader(HeaderBuilder h) {
        this.writeHeader(h, null);
    }

    public void writeHeader(HeaderBuilder h, OutboundEnvelope oe) {
        Object object;
        Object object2;
        Object object3;
        HeaderBuilderImpl header = (HeaderBuilderImpl)h;
        this.byteBuffer().clear();
        this.byteBuffer().put(EnvelopeBuffer$.MODULE$.VersionOffset(), header.version());
        this.byteBuffer().put(EnvelopeBuffer$.MODULE$.FlagsOffset(), header.flags());
        this.byteBuffer().put(EnvelopeBuffer$.MODULE$.ActorRefCompressionTableVersionOffset(), header.outboundActorRefCompression().version());
        this.byteBuffer().put(EnvelopeBuffer$.MODULE$.ClassManifestCompressionTableVersionOffset(), header.outboundClassManifestCompression().version());
        this.byteBuffer().putLong(EnvelopeBuffer$.MODULE$.UidOffset(), header.uid());
        this.byteBuffer().putInt(EnvelopeBuffer$.MODULE$.SerializerOffset(), header.serializer());
        this.byteBuffer().position(EnvelopeBuffer$.MODULE$.MetadataContainerAndLiteralSectionOffset());
        if (OptionVal$.MODULE$.isDefined$extension((Object)header._remoteInstruments())) {
            ((RemoteInstruments)OptionVal$.MODULE$.get$extension((Object)header._remoteInstruments())).serialize((OutboundEnvelope)OptionVal$.MODULE$.apply((Object)oe), this.byteBuffer());
            if (this.byteBuffer().position() != EnvelopeBuffer$.MODULE$.MetadataContainerAndLiteralSectionOffset()) {
                header.setFlag(EnvelopeBuffer$.MODULE$.MetadataPresentFlag());
                object3 = this.byteBuffer().put(EnvelopeBuffer$.MODULE$.FlagsOffset(), header.flags());
            } else {
                object3 = BoxedUnit.UNIT;
            }
        } else {
            object3 = BoxedUnit.UNIT;
        }
        if (header._senderActorRefIdx() != -1) {
            object2 = this.byteBuffer().putInt(EnvelopeBuffer$.MODULE$.SenderActorRefTagOffset(), header._senderActorRefIdx() | EnvelopeBuffer$.MODULE$.TagTypeMask());
        } else {
            this.writeLiteral(EnvelopeBuffer$.MODULE$.SenderActorRefTagOffset(), header._senderActorRef());
            object2 = BoxedUnit.UNIT;
        }
        if (header._recipientActorRefIdx() != -1) {
            object = this.byteBuffer().putInt(EnvelopeBuffer$.MODULE$.RecipientActorRefTagOffset(), header._recipientActorRefIdx() | EnvelopeBuffer$.MODULE$.TagTypeMask());
        } else {
            this.writeLiteral(EnvelopeBuffer$.MODULE$.RecipientActorRefTagOffset(), header._recipientActorRef());
            object = BoxedUnit.UNIT;
        }
        if (header._manifestIdx() != -1) {
            this.byteBuffer().putInt(EnvelopeBuffer$.MODULE$.ClassManifestTagOffset(), header._manifestIdx() | EnvelopeBuffer$.MODULE$.TagTypeMask());
        } else {
            this.writeLiteral(EnvelopeBuffer$.MODULE$.ClassManifestTagOffset(), header._manifest());
        }
    }

    public void parseHeader(HeaderBuilder h) {
        Object object;
        HeaderBuilderImpl header = (HeaderBuilderImpl)h;
        header.setVersion(this.byteBuffer().get(EnvelopeBuffer$.MODULE$.VersionOffset()));
        if (header.version() > ArteryTransport$.MODULE$.HighestVersion()) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incompatible protocol version [", "], "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)header.version())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"highest known version for this node is [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)ArteryTransport$.MODULE$.HighestVersion())}))).toString());
        }
        header.setFlags(this.byteBuffer().get(EnvelopeBuffer$.MODULE$.FlagsOffset()));
        header._inboundActorRefCompressionTableVersion_$eq(this.byteBuffer().get(EnvelopeBuffer$.MODULE$.ActorRefCompressionTableVersionOffset()));
        header._inboundClassManifestCompressionTableVersion_$eq(this.byteBuffer().get(EnvelopeBuffer$.MODULE$.ClassManifestCompressionTableVersionOffset()));
        header.setUid(this.byteBuffer().getLong(EnvelopeBuffer$.MODULE$.UidOffset()));
        header.setSerializer(this.byteBuffer().getInt(EnvelopeBuffer$.MODULE$.SerializerOffset()));
        this.byteBuffer().position(EnvelopeBuffer$.MODULE$.MetadataContainerAndLiteralSectionOffset());
        if (header.flag(EnvelopeBuffer$.MODULE$.MetadataPresentFlag())) {
            int totalMetadataLength = this.byteBuffer().getInt();
            object = this.byteBuffer().position(this.byteBuffer().position() + totalMetadataLength);
        } else {
            object = BoxedUnit.UNIT;
        }
        int senderTag = this.byteBuffer().getInt(EnvelopeBuffer$.MODULE$.SenderActorRefTagOffset());
        if ((senderTag & EnvelopeBuffer$.MODULE$.TagTypeMask()) != 0) {
            int idx = senderTag & EnvelopeBuffer$.MODULE$.TagValueMask();
            header._senderActorRef_$eq(null);
            header._senderActorRefIdx_$eq(idx);
        } else {
            header._senderActorRef_$eq(this.emptyAsNull(this.readLiteral()));
        }
        int recipientTag = this.byteBuffer().getInt(EnvelopeBuffer$.MODULE$.RecipientActorRefTagOffset());
        if ((recipientTag & EnvelopeBuffer$.MODULE$.TagTypeMask()) != 0) {
            int idx = recipientTag & EnvelopeBuffer$.MODULE$.TagValueMask();
            header._recipientActorRef_$eq(null);
            header._recipientActorRefIdx_$eq(idx);
        } else {
            header._recipientActorRef_$eq(this.emptyAsNull(this.readLiteral()));
        }
        int manifestTag = this.byteBuffer().getInt(EnvelopeBuffer$.MODULE$.ClassManifestTagOffset());
        if ((manifestTag & EnvelopeBuffer$.MODULE$.TagTypeMask()) != 0) {
            int idx = manifestTag & EnvelopeBuffer$.MODULE$.TagValueMask();
            header._manifest_$eq(null);
            header._manifestIdx_$eq(idx);
        } else {
            header._manifest_$eq(this.readLiteral());
        }
    }

    private String emptyAsNull(String s) {
        String string = s;
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null) ? null : s;
    }

    private String readLiteral() {
        String string;
        int length = this.byteBuffer().getShort();
        if (length == 0) {
            string = "";
        } else {
            this.ensureLiteralCharsLength(length);
            char[] chars = this.literalChars();
            byte[] bytes = this.literalBytes();
            this.byteBuffer().get(bytes, 0, length);
            for (int i = 0; i < length; ++i) {
                chars[i] = (char)bytes[i];
            }
            string = String.valueOf(chars, 0, length);
        }
        return string;
    }

    private void writeLiteral(int tagOffset, String literal) {
        int length;
        int n = length = literal == null ? 0 : literal.length();
        if (length > 65535) {
            throw new IllegalArgumentException("Literals longer than 65535 cannot be encoded in the envelope");
        }
        this.byteBuffer().putInt(tagOffset, this.byteBuffer().position());
        this.byteBuffer().putShort((short)length);
        if (length > 0) {
            this.ensureLiteralCharsLength(length);
            byte[] bytes = this.literalBytes();
            Unsafe.copyUSAsciiStrToBytes((String)literal, (byte[])bytes);
            this.byteBuffer().put(bytes, 0, length);
        }
    }

    private void ensureLiteralCharsLength(int length) {
        if (length > this.literalChars().length) {
            this.literalChars_$eq(new char[length]);
            this.literalBytes_$eq(new byte[length]);
        }
    }

    public void tryCleanDirectByteBuffer() {
        DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(this.byteBuffer());
    }

    public EnvelopeBuffer copy() {
        int p = this.byteBuffer().position();
        this.byteBuffer().rewind();
        byte[] bytes = new byte[this.byteBuffer().remaining()];
        this.byteBuffer().get(bytes);
        ByteBuffer newByteBuffer = ByteBuffer.wrap(bytes);
        newByteBuffer.position(p);
        this.byteBuffer().position(p);
        return new EnvelopeBuffer(newByteBuffer);
    }

    public EnvelopeBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.aeronBuffer = new UnsafeBuffer(byteBuffer);
        this.literalChars = new char[64];
        this.literalBytes = new byte[64];
        this._streamId = -1;
    }
}

