/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;

public class DispatcherThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final String threadName;
    private final ClassLoader classLoader;

    public DispatcherThreadFactory(ThreadGroup group, String threadName) {
        this(group, threadName, null);
    }

    public DispatcherThreadFactory(ThreadGroup group, String threadName, @Nullable ClassLoader classLoader) {
        this.group = group;
        this.threadName = threadName;
        this.classLoader = classLoader;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.threadName);
        if (this.classLoader != null) {
            t.setContextClassLoader(this.classLoader);
        }
        t.setDaemon(true);
        return t;
    }
}

