/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.File;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Duration;

public class TaskManagerConfiguration
implements TaskManagerRuntimeInfo {
    private static final Logger LOG = LoggerFactory.getLogger(TaskManagerConfiguration.class);
    private final int numberSlots;
    private final String[] tmpDirectories;
    private final Time timeout;
    private final Time maxRegistrationDuration;
    private final Time initialRegistrationPause;
    private final Time maxRegistrationPause;
    private final Time refusedRegistrationPause;
    private final UnmodifiableConfiguration configuration;
    private final boolean exitJvmOnOutOfMemory;
    private final FlinkUserCodeClassLoaders.ResolveOrder classLoaderResolveOrder;
    private final String[] alwaysParentFirstLoaderPatterns;

    public TaskManagerConfiguration(int numberSlots, String[] tmpDirectories, Time timeout, Time maxRegistrationDuration, Time initialRegistrationPause, Time maxRegistrationPause, Time refusedRegistrationPause, long cleanupInterval, Configuration configuration, boolean exitJvmOnOutOfMemory, FlinkUserCodeClassLoaders.ResolveOrder classLoaderResolveOrder, String[] alwaysParentFirstLoaderPatterns) {
        this.numberSlots = numberSlots;
        this.tmpDirectories = (String[])Preconditions.checkNotNull((Object)tmpDirectories);
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout);
        this.maxRegistrationDuration = maxRegistrationDuration;
        this.initialRegistrationPause = (Time)Preconditions.checkNotNull((Object)initialRegistrationPause);
        this.maxRegistrationPause = (Time)Preconditions.checkNotNull((Object)maxRegistrationPause);
        this.refusedRegistrationPause = (Time)Preconditions.checkNotNull((Object)refusedRegistrationPause);
        this.configuration = new UnmodifiableConfiguration((Configuration)Preconditions.checkNotNull((Object)configuration));
        this.exitJvmOnOutOfMemory = exitJvmOnOutOfMemory;
        this.classLoaderResolveOrder = classLoaderResolveOrder;
        this.alwaysParentFirstLoaderPatterns = alwaysParentFirstLoaderPatterns;
    }

    public int getNumberSlots() {
        return this.numberSlots;
    }

    public Time getTimeout() {
        return this.timeout;
    }

    public Time getMaxRegistrationDuration() {
        return this.maxRegistrationDuration;
    }

    public Time getInitialRegistrationPause() {
        return this.initialRegistrationPause;
    }

    public Time getMaxRegistrationPause() {
        return this.maxRegistrationPause;
    }

    public Time getRefusedRegistrationPause() {
        return this.refusedRegistrationPause;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String[] getTmpDirectories() {
        return this.tmpDirectories;
    }

    @Override
    public boolean shouldExitJvmOnOutOfMemoryError() {
        return this.exitJvmOnOutOfMemory;
    }

    public FlinkUserCodeClassLoaders.ResolveOrder getClassLoaderResolveOrder() {
        return this.classLoaderResolveOrder;
    }

    public String[] getAlwaysParentFirstLoaderPatterns() {
        return this.alwaysParentFirstLoaderPatterns;
    }

    public static TaskManagerConfiguration fromConfiguration(Configuration configuration) {
        Time refusedRegistrationPause;
        Time maxRegistrationPause;
        Time initialRegistrationPause;
        Time finiteRegistrationDuration;
        Time timeout;
        int numberSlots = configuration.getInteger("taskmanager.numberOfTaskSlots", 1);
        if (numberSlots == -1) {
            numberSlots = 1;
        }
        String[] tmpDirPaths = configuration.getString("taskmanager.tmp.dirs", ConfigConstants.DEFAULT_TASK_MANAGER_TMP_PATH).split(",|" + File.pathSeparator);
        try {
            timeout = Time.milliseconds((long)AkkaUtils.getTimeout(configuration).toMillis());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid format for '" + AkkaOptions.ASK_TIMEOUT.key() + "'.Use formats like '50 s' or '1 min' to specify the timeout.");
        }
        LOG.info("Messages have a max timeout of " + timeout);
        long cleanupInterval = configuration.getLong(BlobServerOptions.CLEANUP_INTERVAL) * 1000L;
        try {
            Duration maxRegistrationDuration = Duration.create((String)configuration.getString("taskmanager.maxRegistrationDuration", "Inf"));
            finiteRegistrationDuration = maxRegistrationDuration.isFinite() ? Time.milliseconds((long)maxRegistrationDuration.toMillis()) : null;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid format for parameter taskmanager.maxRegistrationDuration", e);
        }
        try {
            Duration pause = Duration.create((String)configuration.getString("taskmanager.initial-registration-pause", "500 ms"));
            if (!pause.isFinite()) {
                throw new IllegalArgumentException("The initial registration pause must be finite: " + pause);
            }
            initialRegistrationPause = Time.milliseconds((long)pause.toMillis());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid format for parameter taskmanager.initial-registration-pause", e);
        }
        try {
            Duration pause = Duration.create((String)configuration.getString("taskmanager.max-registration-pause", "30 s"));
            if (!pause.isFinite()) {
                throw new IllegalArgumentException("The maximum registration pause must be finite: " + pause);
            }
            maxRegistrationPause = Time.milliseconds((long)pause.toMillis());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid format for parameter taskmanager.initial-registration-pause", e);
        }
        try {
            Duration pause = Duration.create((String)configuration.getString("taskmanager.refused-registration-pause", "10 s"));
            if (!pause.isFinite()) {
                throw new IllegalArgumentException("The refused registration pause must be finite: " + pause);
            }
            refusedRegistrationPause = Time.milliseconds((long)pause.toMillis());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid format for parameter taskmanager.initial-registration-pause", e);
        }
        boolean exitOnOom = configuration.getBoolean(TaskManagerOptions.KILL_ON_OUT_OF_MEMORY);
        String classLoaderResolveOrder = configuration.getString(CoreOptions.CLASSLOADER_RESOLVE_ORDER);
        String alwaysParentFirstLoaderString = configuration.getString(CoreOptions.ALWAYS_PARENT_FIRST_LOADER);
        String[] alwaysParentFirstLoaderPatterns = alwaysParentFirstLoaderString.split(";");
        return new TaskManagerConfiguration(numberSlots, tmpDirPaths, timeout, finiteRegistrationDuration, initialRegistrationPause, maxRegistrationPause, refusedRegistrationPause, cleanupInterval, configuration, exitOnOom, FlinkUserCodeClassLoaders.ResolveOrder.fromString(classLoaderResolveOrder), alwaysParentFirstLoaderPatterns);
    }
}

