/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.IOException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.DefaultOperatorStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackend;
import org.apache.flink.runtime.state.memory.MemCheckpointStreamFactory;

public class MemoryStateBackend
extends AbstractStateBackend {
    private static final long serialVersionUID = 4109305377809414635L;
    private static final int DEFAULT_MAX_STATE_SIZE = 0x500000;
    private final int maxStateSize;
    private final boolean asynchronousSnapshots;

    public MemoryStateBackend() {
        this(0x500000);
    }

    public MemoryStateBackend(int maxStateSize) {
        this(maxStateSize, true);
    }

    public MemoryStateBackend(boolean asynchronousSnapshots) {
        this(0x500000, asynchronousSnapshots);
    }

    public MemoryStateBackend(int maxStateSize, boolean asynchronousSnapshots) {
        this.maxStateSize = maxStateSize;
        this.asynchronousSnapshots = asynchronousSnapshots;
    }

    @Override
    public OperatorStateBackend createOperatorStateBackend(Environment env, String operatorIdentifier) throws Exception {
        return new DefaultOperatorStateBackend(env.getUserClassLoader(), env.getExecutionConfig(), this.asynchronousSnapshots);
    }

    public String toString() {
        return "MemoryStateBackend (data in heap memory / checkpoints to JobManager)";
    }

    @Override
    public CheckpointStreamFactory createStreamFactory(JobID jobId, String operatorIdentifier) throws IOException {
        return new MemCheckpointStreamFactory(this.maxStateSize);
    }

    @Override
    public CheckpointStreamFactory createSavepointStreamFactory(JobID jobId, String operatorIdentifier, String targetLocation) throws IOException {
        return new MemCheckpointStreamFactory(this.maxStateSize);
    }

    @Override
    public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(Environment env, JobID jobID, String operatorIdentifier, TypeSerializer<K> keySerializer, int numberOfKeyGroups, KeyGroupRange keyGroupRange, TaskKvStateRegistry kvStateRegistry) {
        return new HeapKeyedStateBackend<K>(kvStateRegistry, keySerializer, env.getUserClassLoader(), numberOfKeyGroups, keyGroupRange, this.asynchronousSnapshots, env.getExecutionConfig());
    }
}

