/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.concurrent.RunnableFuture;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.util.FutureUtil;
import org.apache.flink.util.LambdaUtil;

public class StateUtil {
    private StateUtil() {
        throw new AssertionError();
    }

    public static long getStateSize(StateObject handle) {
        return handle == null ? 0L : handle.getStateSize();
    }

    public static void bestEffortDiscardAllStateObjects(Iterable<? extends StateObject> handlesToDiscard) throws Exception {
        LambdaUtil.applyToAllWhileSuppressingExceptions(handlesToDiscard, StateObject::discardState);
    }

    public static void discardStateFuture(RunnableFuture<? extends StateObject> stateFuture) throws Exception {
        StateObject stateObject;
        if (null != stateFuture && !stateFuture.cancel(true) && null != (stateObject = (StateObject)FutureUtil.runIfNotDoneAndGet(stateFuture))) {
            stateObject.discardState();
        }
    }
}

