/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeOffsets;
import org.apache.flink.runtime.state.KeyGroupsList;
import org.apache.flink.runtime.state.KeyGroupsStateHandle;
import org.apache.flink.runtime.state.NonClosingCheckpointOutputStream;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class KeyedStateCheckpointOutputStream
extends NonClosingCheckpointOutputStream<KeyGroupsStateHandle> {
    public static final long NO_OFFSET_SET = -1L;
    public static final int NO_CURRENT_KEY_GROUP = -1;
    private int currentKeyGroup;
    private final KeyGroupRangeOffsets keyGroupRangeOffsets;

    public KeyedStateCheckpointOutputStream(CheckpointStreamFactory.CheckpointStateOutputStream delegate2, KeyGroupRange keyGroupRange) {
        super(delegate2);
        Preconditions.checkNotNull((Object)keyGroupRange);
        Preconditions.checkArgument((keyGroupRange != KeyGroupRange.EMPTY_KEY_GROUP_RANGE ? 1 : 0) != 0);
        this.currentKeyGroup = -1;
        long[] emptyOffsets = new long[keyGroupRange.getNumberOfKeyGroups()];
        Arrays.fill(emptyOffsets, -1L);
        this.keyGroupRangeOffsets = new KeyGroupRangeOffsets(keyGroupRange, emptyOffsets);
    }

    @Override
    public void close() throws IOException {
    }

    public KeyGroupsList getKeyGroupList() {
        return this.keyGroupRangeOffsets.getKeyGroupRange();
    }

    public void startNewKeyGroup(int keyGroupId) throws IOException {
        if (this.isKeyGroupAlreadyStarted(keyGroupId)) {
            throw new IOException("Key group " + keyGroupId + " already registered!");
        }
        this.keyGroupRangeOffsets.setKeyGroupOffset(keyGroupId, this.delegate.getPos());
        this.currentKeyGroup = keyGroupId;
    }

    public boolean isKeyGroupAlreadyStarted(int keyGroupId) {
        return -1L != this.keyGroupRangeOffsets.getKeyGroupOffset(keyGroupId);
    }

    public boolean isKeyGroupAlreadyFinished(int keyGroupId) {
        return this.isKeyGroupAlreadyStarted(keyGroupId) && keyGroupId != this.getCurrentKeyGroup();
    }

    public int getCurrentKeyGroup() {
        return this.currentKeyGroup;
    }

    @Override
    KeyGroupsStateHandle closeAndGetHandle() throws IOException {
        StreamStateHandle streamStateHandle = this.delegate.closeAndGetHandle();
        return streamStateHandle != null ? new KeyGroupsStateHandle(this.keyGroupRangeOffsets, streamStateHandle) : null;
    }
}

