/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.CompatibilityUtil;
import org.apache.flink.api.common.typeutils.TypeDeserializerAdapter;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializerConfigSnapshot;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@Internal
public final class HashMapSerializer<K, V>
extends TypeSerializer<HashMap<K, V>> {
    private static final long serialVersionUID = -6885593032367050078L;
    private final TypeSerializer<K> keySerializer;
    private final TypeSerializer<V> valueSerializer;

    public HashMapSerializer(TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer) {
        this.keySerializer = (TypeSerializer)Preconditions.checkNotNull(keySerializer, (String)"The key serializer cannot be null");
        this.valueSerializer = (TypeSerializer)Preconditions.checkNotNull(valueSerializer, (String)"The value serializer cannot be null.");
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public TypeSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<HashMap<K, V>> duplicate() {
        TypeSerializer duplicateKeySerializer = this.keySerializer.duplicate();
        TypeSerializer duplicateValueSerializer = this.valueSerializer.duplicate();
        return new HashMapSerializer<K, V>(duplicateKeySerializer, duplicateValueSerializer);
    }

    public HashMap<K, V> createInstance() {
        return new HashMap();
    }

    public HashMap<K, V> copy(HashMap<K, V> from) {
        HashMap<Object, Object> newHashMap = new HashMap<Object, Object>(from.size());
        for (Map.Entry<K, V> entry : from.entrySet()) {
            Object newKey = this.keySerializer.copy(entry.getKey());
            Object newValue = entry.getValue() == null ? null : this.valueSerializer.copy(entry.getValue());
            newHashMap.put(newKey, newValue);
        }
        return newHashMap;
    }

    public HashMap<K, V> copy(HashMap<K, V> from, HashMap<K, V> reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(HashMap<K, V> map, DataOutputView target) throws IOException {
        int size = map.size();
        target.writeInt(size);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.keySerializer.serialize(entry.getKey(), target);
            if (entry.getValue() == null) {
                target.writeBoolean(true);
                continue;
            }
            target.writeBoolean(false);
            this.valueSerializer.serialize(entry.getValue(), target);
        }
    }

    public HashMap<K, V> deserialize(DataInputView source) throws IOException {
        int size = source.readInt();
        HashMap<Object, Object> map = new HashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            Object key = this.keySerializer.deserialize(source);
            boolean isNull = source.readBoolean();
            Object value = isNull ? null : this.valueSerializer.deserialize(source);
            map.put(key, value);
        }
        return map;
    }

    public HashMap<K, V> deserialize(HashMap<K, V> reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int size = source.readInt();
        target.writeInt(size);
        for (int i = 0; i < size; ++i) {
            this.keySerializer.copy(source, target);
            boolean isNull = source.readBoolean();
            target.writeBoolean(isNull);
            if (isNull) continue;
            this.valueSerializer.copy(source, target);
        }
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == ((Object)((Object)this)).getClass() && this.keySerializer.equals(((HashMapSerializer)((Object)obj)).getKeySerializer()) && this.valueSerializer.equals(((HashMapSerializer)((Object)obj)).getValueSerializer());
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj.getClass() == ((Object)((Object)this)).getClass();
    }

    public int hashCode() {
        return this.keySerializer.hashCode() * 31 + this.valueSerializer.hashCode();
    }

    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        return new MapSerializerConfigSnapshot(this.keySerializer, this.valueSerializer);
    }

    public CompatibilityResult<HashMap<K, V>> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        if (configSnapshot instanceof MapSerializerConfigSnapshot) {
            List previousKvSerializersAndConfigs = ((MapSerializerConfigSnapshot)configSnapshot).getNestedSerializersAndConfigs();
            CompatibilityResult keyCompatResult = CompatibilityUtil.resolveCompatibilityResult((TypeSerializer)((TypeSerializer)((Tuple2)previousKvSerializersAndConfigs.get((int)0)).f0), UnloadableDummyTypeSerializer.class, (TypeSerializerConfigSnapshot)((TypeSerializerConfigSnapshot)((Tuple2)previousKvSerializersAndConfigs.get((int)0)).f1), this.keySerializer);
            CompatibilityResult valueCompatResult = CompatibilityUtil.resolveCompatibilityResult((TypeSerializer)((TypeSerializer)((Tuple2)previousKvSerializersAndConfigs.get((int)1)).f0), UnloadableDummyTypeSerializer.class, (TypeSerializerConfigSnapshot)((TypeSerializerConfigSnapshot)((Tuple2)previousKvSerializersAndConfigs.get((int)1)).f1), this.valueSerializer);
            if (!keyCompatResult.isRequiresMigration() && !valueCompatResult.isRequiresMigration()) {
                return CompatibilityResult.compatible();
            }
            if (keyCompatResult.getConvertDeserializer() != null && valueCompatResult.getConvertDeserializer() != null) {
                return CompatibilityResult.requiresMigration(new HashMapSerializer<K, V>(new TypeDeserializerAdapter(keyCompatResult.getConvertDeserializer()), new TypeDeserializerAdapter(valueCompatResult.getConvertDeserializer())));
            }
        }
        return CompatibilityResult.requiresMigration();
    }
}

