/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Objects;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.AggregatingState;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.FoldingState;
import org.apache.flink.api.common.state.FoldingStateDescriptor;
import org.apache.flink.api.common.state.KeyedStateStore;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.UserFacingListState;
import org.apache.flink.runtime.state.UserFacingMapState;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.util.Preconditions;

public class DefaultKeyedStateStore
implements KeyedStateStore {
    private final KeyedStateBackend<?> keyedStateBackend;
    private final ExecutionConfig executionConfig;

    public DefaultKeyedStateStore(KeyedStateBackend<?> keyedStateBackend, ExecutionConfig executionConfig) {
        this.keyedStateBackend = (KeyedStateBackend)Preconditions.checkNotNull(keyedStateBackend);
        this.executionConfig = (ExecutionConfig)Preconditions.checkNotNull((Object)executionConfig);
    }

    public <T> ValueState<T> getState(ValueStateDescriptor<T> stateProperties) {
        Objects.requireNonNull(stateProperties, "The state properties must not be null");
        try {
            stateProperties.initializeSerializerUnlessSet(this.executionConfig);
            return (ValueState)this.getPartitionedState((StateDescriptor)stateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    public <T> ListState<T> getListState(ListStateDescriptor<T> stateProperties) {
        Objects.requireNonNull(stateProperties, "The state properties must not be null");
        try {
            stateProperties.initializeSerializerUnlessSet(this.executionConfig);
            ListState originalState = (ListState)this.getPartitionedState((StateDescriptor)stateProperties);
            return new UserFacingListState(originalState);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    public <T> ReducingState<T> getReducingState(ReducingStateDescriptor<T> stateProperties) {
        Objects.requireNonNull(stateProperties, "The state properties must not be null");
        try {
            stateProperties.initializeSerializerUnlessSet(this.executionConfig);
            return (ReducingState)this.getPartitionedState((StateDescriptor)stateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    public <IN, ACC, OUT> AggregatingState<IN, OUT> getAggregatingState(AggregatingStateDescriptor<IN, ACC, OUT> stateProperties) {
        Objects.requireNonNull(stateProperties, "The state properties must not be null");
        try {
            stateProperties.initializeSerializerUnlessSet(this.executionConfig);
            return (AggregatingState)this.getPartitionedState((StateDescriptor)stateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    public <T, ACC> FoldingState<T, ACC> getFoldingState(FoldingStateDescriptor<T, ACC> stateProperties) {
        Objects.requireNonNull(stateProperties, "The state properties must not be null");
        try {
            stateProperties.initializeSerializerUnlessSet(this.executionConfig);
            return (FoldingState)this.getPartitionedState((StateDescriptor)stateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    public <UK, UV> MapState<UK, UV> getMapState(MapStateDescriptor<UK, UV> stateProperties) {
        Objects.requireNonNull(stateProperties, "The state properties must not be null");
        try {
            stateProperties.initializeSerializerUnlessSet(this.executionConfig);
            MapState originalState = (MapState)this.getPartitionedState((StateDescriptor)stateProperties);
            return new UserFacingMapState(originalState);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    private <S extends State> S getPartitionedState(StateDescriptor<S, ?> stateDescriptor) throws Exception {
        return this.keyedStateBackend.getPartitionedState(VoidNamespace.INSTANCE, VoidNamespaceSerializer.INSTANCE, stateDescriptor);
    }
}

