/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rpc.MainThreadExecutable;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcServer;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcEndpoint
implements RpcGateway {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RpcService rpcService;
    private final String endpointId;
    protected final RpcServer rpcServer;
    final AtomicReference<Thread> currentMainThread = new AtomicReference<Object>(null);
    private final MainThreadExecutor mainThreadExecutor;

    protected RpcEndpoint(RpcService rpcService, String endpointId) {
        this.rpcService = (RpcService)Preconditions.checkNotNull((Object)rpcService, (String)"rpcService");
        this.endpointId = (String)Preconditions.checkNotNull((Object)endpointId, (String)"endpointId");
        this.rpcServer = rpcService.startServer(this);
        this.mainThreadExecutor = new MainThreadExecutor(this.rpcServer);
    }

    protected RpcEndpoint(RpcService rpcService) {
        this(rpcService, UUID.randomUUID().toString());
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public void start() throws Exception {
        this.rpcServer.start();
    }

    protected final void stop() {
        this.rpcServer.stop();
    }

    public void postStop() throws Exception {
    }

    public final void shutDown() {
        this.rpcService.stopServer(this.rpcServer);
    }

    public <C extends RpcGateway> C getSelfGateway(Class<C> selfGatewayType) {
        if (selfGatewayType.isInstance(this.rpcServer)) {
            RpcServer selfGateway = this.rpcServer;
            return (C)selfGateway;
        }
        throw new RuntimeException("RpcEndpoint does not implement the RpcGateway interface of type " + selfGatewayType + '.');
    }

    @Override
    public String getAddress() {
        return this.rpcServer.getAddress();
    }

    @Override
    public String getHostname() {
        return this.rpcServer.getHostname();
    }

    protected MainThreadExecutor getMainThreadExecutor() {
        return this.mainThreadExecutor;
    }

    public RpcService getRpcService() {
        return this.rpcService;
    }

    public CompletableFuture<Boolean> getTerminationFuture() {
        return this.rpcServer.getTerminationFuture();
    }

    protected void runAsync(Runnable runnable) {
        this.rpcServer.runAsync(runnable);
    }

    protected void scheduleRunAsync(Runnable runnable, Time delay) {
        this.scheduleRunAsync(runnable, delay.getSize(), delay.getUnit());
    }

    protected void scheduleRunAsync(Runnable runnable, long delay, TimeUnit unit) {
        this.rpcServer.scheduleRunAsync(runnable, unit.toMillis(delay));
    }

    protected <V> CompletableFuture<V> callAsync(Callable<V> callable, Time timeout) {
        return this.rpcServer.callAsync(callable, timeout);
    }

    public void validateRunsInMainThread() {
        assert (this.currentMainThread.get() == Thread.currentThread());
    }

    protected static class MainThreadExecutor
    implements Executor {
        private final MainThreadExecutable gateway;

        MainThreadExecutor(MainThreadExecutable gateway) {
            this.gateway = (MainThreadExecutable)Preconditions.checkNotNull((Object)gateway);
        }

        @Override
        public void execute(@Nonnull Runnable runnable) {
            this.gateway.runAsync(runnable);
        }
    }
}

