/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.util.Preconditions;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class JobPlanInfo
implements ResponseBody {
    private final String jsonPlan;

    public JobPlanInfo(String jsonPlan) {
        this.jsonPlan = (String)Preconditions.checkNotNull((Object)jsonPlan);
    }

    public String getJsonPlan() {
        return this.jsonPlan;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobPlanInfo that = (JobPlanInfo)o;
        return Objects.equals(this.jsonPlan, that.jsonPlan);
    }

    public int hashCode() {
        return Objects.hash(this.jsonPlan);
    }

    public static final class Deserializer
    extends StdDeserializer<JobPlanInfo> {
        private static final long serialVersionUID = -3580088509877177213L;

        public Deserializer() {
            super(JobPlanInfo.class);
        }

        public JobPlanInfo deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String jsonPlan = jsonParser.getText();
            return new JobPlanInfo(jsonPlan);
        }
    }

    public static final class Serializer
    extends StdSerializer<JobPlanInfo> {
        private static final long serialVersionUID = -1551666039618928811L;

        public Serializer() {
            super(JobPlanInfo.class);
        }

        public void serialize(JobPlanInfo jobPlanInfo, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(jobPlanInfo.getJsonPlan());
        }
    }
}

