/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.util;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;

public class MutableIOMetrics
extends IOMetrics {
    private static final long serialVersionUID = -5460777634971381737L;
    private boolean numBytesInLocalComplete = true;
    private boolean numBytesInRemoteComplete = true;
    private boolean numBytesOutComplete = true;
    private boolean numRecordsInComplete = true;
    private boolean numRecordsOutComplete = true;

    public MutableIOMetrics() {
        super(0, 0, 0, 0, 0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public void addIOMetrics(AccessExecution attempt, @Nullable MetricFetcher fetcher, String jobID, String taskID) {
        if (attempt.getState().isTerminal()) {
            IOMetrics ioMetrics = attempt.getIOMetrics();
            if (ioMetrics != null) {
                this.numBytesInLocal += ioMetrics.getNumBytesInLocal();
                this.numBytesInRemote += ioMetrics.getNumBytesInRemote();
                this.numBytesOut += ioMetrics.getNumBytesOut();
                this.numRecordsIn += ioMetrics.getNumRecordsIn();
                this.numRecordsOut += ioMetrics.getNumRecordsOut();
            }
        } else if (fetcher != null) {
            fetcher.update();
            MetricStore.ComponentMetricStore metrics = fetcher.getMetricStore().getSubtaskMetricStore(jobID, taskID, attempt.getParallelSubtaskIndex());
            if (metrics != null) {
                if (metrics.getMetric("numBytesInLocal") == null) {
                    this.numBytesInLocalComplete = false;
                } else {
                    this.numBytesInLocal += Long.valueOf(metrics.getMetric("numBytesInLocal")).longValue();
                }
                if (metrics.getMetric("numBytesInRemote") == null) {
                    this.numBytesInRemoteComplete = false;
                } else {
                    this.numBytesInRemote += Long.valueOf(metrics.getMetric("numBytesInRemote")).longValue();
                }
                if (metrics.getMetric("numBytesOut") == null) {
                    this.numBytesOutComplete = false;
                } else {
                    this.numBytesOut += Long.valueOf(metrics.getMetric("numBytesOut")).longValue();
                }
                if (metrics.getMetric("numRecordsIn") == null) {
                    this.numRecordsInComplete = false;
                } else {
                    this.numRecordsIn += Long.valueOf(metrics.getMetric("numRecordsIn")).longValue();
                }
                if (metrics.getMetric("numRecordsOut") == null) {
                    this.numRecordsOutComplete = false;
                } else {
                    this.numRecordsOut += Long.valueOf(metrics.getMetric("numRecordsOut")).longValue();
                }
            } else {
                this.numBytesInLocalComplete = false;
                this.numBytesInRemoteComplete = false;
                this.numBytesOutComplete = false;
                this.numRecordsInComplete = false;
                this.numRecordsOutComplete = false;
            }
        }
    }

    public void writeIOMetricsAsJson(JsonGenerator gen) throws IOException {
        gen.writeObjectFieldStart("metrics");
        Long numBytesIn = this.numBytesInLocal + this.numBytesInRemote;
        gen.writeNumberField("read-bytes", numBytesIn.longValue());
        gen.writeBooleanField("read-bytes-complete", this.numBytesInLocalComplete && this.numBytesInRemoteComplete);
        gen.writeNumberField("write-bytes", this.numBytesOut);
        gen.writeBooleanField("write-bytes-complete", this.numBytesOutComplete);
        gen.writeNumberField("read-records", this.numRecordsIn);
        gen.writeBooleanField("read-records-complete", this.numRecordsInComplete);
        gen.writeNumberField("write-records", this.numRecordsOut);
        gen.writeBooleanField("write-records-complete", this.numRecordsOutComplete);
        gen.writeEndObject();
    }
}

