/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.metrics;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.metrics.dump.MetricDump;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MetricStore {
    private static final Logger LOG = LoggerFactory.getLogger(MetricStore.class);
    private final ComponentMetricStore jobManager = new ComponentMetricStore();
    private final Map<String, TaskManagerMetricStore> taskManagers = new ConcurrentHashMap<String, TaskManagerMetricStore>();
    private final Map<String, JobMetricStore> jobs = new ConcurrentHashMap<String, JobMetricStore>();

    synchronized void retainTaskManagers(List<String> activeTaskManagers) {
        this.taskManagers.keySet().retainAll(activeTaskManagers);
    }

    synchronized void retainJobs(List<String> activeJobs) {
        this.jobs.keySet().retainAll(activeJobs);
    }

    synchronized void addAll(List<MetricDump> metricDumps) {
        for (MetricDump metric : metricDumps) {
            this.add(metric);
        }
    }

    public synchronized ComponentMetricStore getJobManagerMetricStore() {
        return ComponentMetricStore.unmodifiable(this.jobManager);
    }

    public synchronized TaskManagerMetricStore getTaskManagerMetricStore(String tmID) {
        return tmID == null ? null : TaskManagerMetricStore.unmodifiable(this.taskManagers.get(tmID));
    }

    public synchronized ComponentMetricStore getJobMetricStore(String jobID) {
        return jobID == null ? null : ComponentMetricStore.unmodifiable((ComponentMetricStore)this.jobs.get(jobID));
    }

    public synchronized TaskMetricStore getTaskMetricStore(String jobID, String taskID) {
        JobMetricStore job;
        JobMetricStore jobMetricStore = job = jobID == null ? null : this.jobs.get(jobID);
        if (job == null || taskID == null) {
            return null;
        }
        return TaskMetricStore.unmodifiable(job.getTaskMetricStore(taskID));
    }

    public synchronized ComponentMetricStore getSubtaskMetricStore(String jobID, String taskID, int subtaskIndex) {
        JobMetricStore job;
        JobMetricStore jobMetricStore = job = jobID == null ? null : this.jobs.get(jobID);
        if (job == null) {
            return null;
        }
        TaskMetricStore task = job.getTaskMetricStore(taskID);
        if (task == null) {
            return null;
        }
        return ComponentMetricStore.unmodifiable(task.getSubtaskMetricStore(subtaskIndex));
    }

    public synchronized Map<String, JobMetricStore> getJobs() {
        return Collections.unmodifiableMap(this.jobs);
    }

    public synchronized Map<String, TaskManagerMetricStore> getTaskManagers() {
        return Collections.unmodifiableMap(this.taskManagers);
    }

    public synchronized ComponentMetricStore getJobManager() {
        return ComponentMetricStore.unmodifiable(this.jobManager);
    }

    @VisibleForTesting
    void add(MetricDump metric) {
        try {
            String name;
            QueryScopeInfo info = metric.scopeInfo;
            String string = name = info.scope.isEmpty() ? metric.name : info.scope + "." + metric.name;
            if (name.isEmpty()) {
                return;
            }
            switch (info.getCategory()) {
                case 0: {
                    this.addMetric(this.jobManager.metrics, name, metric);
                    break;
                }
                case 1: {
                    String tmID = ((QueryScopeInfo.TaskManagerQueryScopeInfo)info).taskManagerID;
                    TaskManagerMetricStore tm = this.taskManagers.computeIfAbsent(tmID, k -> new TaskManagerMetricStore());
                    if (name.contains("GarbageCollector")) {
                        String gcName = name.substring("Status.JVM.GarbageCollector.".length(), name.lastIndexOf(46));
                        tm.addGarbageCollectorName(gcName);
                    }
                    this.addMetric(tm.metrics, name, metric);
                    break;
                }
                case 2: {
                    QueryScopeInfo.JobQueryScopeInfo jobInfo = (QueryScopeInfo.JobQueryScopeInfo)info;
                    JobMetricStore job = this.jobs.computeIfAbsent(jobInfo.jobID, k -> new JobMetricStore());
                    this.addMetric(job.metrics, name, metric);
                    break;
                }
                case 3: {
                    QueryScopeInfo.TaskQueryScopeInfo taskInfo = (QueryScopeInfo.TaskQueryScopeInfo)info;
                    JobMetricStore job = this.jobs.computeIfAbsent(taskInfo.jobID, k -> new JobMetricStore());
                    TaskMetricStore task = job.tasks.computeIfAbsent(taskInfo.vertexID, k -> new TaskMetricStore());
                    ComponentMetricStore subtask = task.subtasks.computeIfAbsent(taskInfo.subtaskIndex, k -> new ComponentMetricStore());
                    this.addMetric(subtask.metrics, name, metric);
                    this.addMetric(task.metrics, taskInfo.subtaskIndex + "." + name, metric);
                    break;
                }
                case 4: {
                    QueryScopeInfo.OperatorQueryScopeInfo operatorInfo = (QueryScopeInfo.OperatorQueryScopeInfo)info;
                    JobMetricStore job = this.jobs.computeIfAbsent(operatorInfo.jobID, k -> new JobMetricStore());
                    TaskMetricStore task = job.tasks.computeIfAbsent(operatorInfo.vertexID, k -> new TaskMetricStore());
                    ComponentMetricStore subtask = task.subtasks.computeIfAbsent(operatorInfo.subtaskIndex, k -> new ComponentMetricStore());
                    this.addMetric(subtask.metrics, operatorInfo.operatorName + "." + name, metric);
                    this.addMetric(task.metrics, operatorInfo.subtaskIndex + "." + operatorInfo.operatorName + "." + name, metric);
                    break;
                }
                default: {
                    LOG.debug("Invalid metric dump category: " + info.getCategory());
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.debug("Malformed metric dump.", (Throwable)e);
        }
    }

    private void addMetric(Map<String, String> target, String name, MetricDump metric) {
        switch (metric.getCategory()) {
            case 0: {
                MetricDump.CounterDump counter = (MetricDump.CounterDump)metric;
                target.put(name, String.valueOf(counter.count));
                break;
            }
            case 1: {
                MetricDump.GaugeDump gauge = (MetricDump.GaugeDump)metric;
                target.put(name, gauge.value);
                break;
            }
            case 2: {
                MetricDump.HistogramDump histogram = (MetricDump.HistogramDump)metric;
                target.put(name + "_min", String.valueOf(histogram.min));
                target.put(name + "_max", String.valueOf(histogram.max));
                target.put(name + "_mean", String.valueOf(histogram.mean));
                target.put(name + "_median", String.valueOf(histogram.median));
                target.put(name + "_stddev", String.valueOf(histogram.stddev));
                target.put(name + "_p75", String.valueOf(histogram.p75));
                target.put(name + "_p90", String.valueOf(histogram.p90));
                target.put(name + "_p95", String.valueOf(histogram.p95));
                target.put(name + "_p98", String.valueOf(histogram.p98));
                target.put(name + "_p99", String.valueOf(histogram.p99));
                target.put(name + "_p999", String.valueOf(histogram.p999));
                break;
            }
            case 3: {
                MetricDump.MeterDump meter = (MetricDump.MeterDump)metric;
                target.put(name, String.valueOf(meter.rate));
            }
        }
    }

    @ThreadSafe
    public static class TaskMetricStore
    extends ComponentMetricStore {
        private final Map<Integer, ComponentMetricStore> subtasks;

        private TaskMetricStore() {
            this(new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<Integer, ComponentMetricStore>());
        }

        private TaskMetricStore(Map<String, String> metrics, Map<Integer, ComponentMetricStore> subtasks) {
            super(metrics);
            this.subtasks = (Map)Preconditions.checkNotNull(subtasks);
        }

        public ComponentMetricStore getSubtaskMetricStore(int subtaskIndex) {
            return this.subtasks.get(subtaskIndex);
        }

        public Collection<ComponentMetricStore> getAllSubtaskMetricStores() {
            return this.subtasks.values();
        }

        private static TaskMetricStore unmodifiable(TaskMetricStore source) {
            if (source == null) {
                return null;
            }
            return new TaskMetricStore(Collections.unmodifiableMap(source.metrics), Collections.unmodifiableMap(source.subtasks));
        }
    }

    @ThreadSafe
    private static class JobMetricStore
    extends ComponentMetricStore {
        private final Map<String, TaskMetricStore> tasks = new ConcurrentHashMap<String, TaskMetricStore>();

        private JobMetricStore() {
        }

        public TaskMetricStore getTaskMetricStore(String taskID) {
            return taskID == null ? null : this.tasks.get(taskID);
        }
    }

    @ThreadSafe
    public static class TaskManagerMetricStore
    extends ComponentMetricStore {
        public final Set<String> garbageCollectorNames;

        private TaskManagerMetricStore() {
            this(new ConcurrentHashMap<String, String>(), ConcurrentHashMap.newKeySet());
        }

        private TaskManagerMetricStore(Map<String, String> metrics, Set<String> garbageCollectorNames) {
            super(metrics);
            this.garbageCollectorNames = (Set)Preconditions.checkNotNull(garbageCollectorNames);
        }

        private void addGarbageCollectorName(String name) {
            this.garbageCollectorNames.add(name);
        }

        private static TaskManagerMetricStore unmodifiable(TaskManagerMetricStore source) {
            if (source == null) {
                return null;
            }
            return new TaskManagerMetricStore(Collections.unmodifiableMap(source.metrics), Collections.unmodifiableSet(source.garbageCollectorNames));
        }
    }

    @ThreadSafe
    public static class ComponentMetricStore {
        public final Map<String, String> metrics;

        private ComponentMetricStore() {
            this(new ConcurrentHashMap<String, String>());
        }

        private ComponentMetricStore(Map<String, String> metrics) {
            this.metrics = (Map)Preconditions.checkNotNull(metrics);
        }

        public String getMetric(String name) {
            return this.metrics.get(name);
        }

        public String getMetric(String name, String defaultValue) {
            String value = this.metrics.get(name);
            return value != null ? value : defaultValue;
        }

        private static ComponentMetricStore unmodifiable(ComponentMetricStore source) {
            if (source == null) {
                return null;
            }
            return new ComponentMetricStore(Collections.unmodifiableMap(source.metrics));
        }
    }
}

