/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.metrics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.messages.webmonitor.MultipleJobsDetails;
import org.apache.flink.runtime.metrics.dump.MetricDumpSerialization;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceGateway;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceRetriever;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricFetcher<T extends RestfulGateway> {
    private static final Logger LOG = LoggerFactory.getLogger(MetricFetcher.class);
    private final GatewayRetriever<T> retriever;
    private final MetricQueryServiceRetriever queryServiceRetriever;
    private final Executor executor;
    private final Time timeout;
    private final MetricStore metrics = new MetricStore();
    private final MetricDumpSerialization.MetricDumpDeserializer deserializer = new MetricDumpSerialization.MetricDumpDeserializer();
    private long lastUpdateTime;

    public MetricFetcher(GatewayRetriever<T> retriever, MetricQueryServiceRetriever queryServiceRetriever, Executor executor, Time timeout) {
        this.retriever = (GatewayRetriever)Preconditions.checkNotNull(retriever);
        this.queryServiceRetriever = (MetricQueryServiceRetriever)Preconditions.checkNotNull((Object)queryServiceRetriever);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout);
    }

    public MetricStore getMetricStore() {
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        MetricFetcher metricFetcher = this;
        synchronized (metricFetcher) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastUpdateTime > 10000L) {
                this.lastUpdateTime = currentTime;
                this.fetchMetrics();
            }
        }
    }

    private void fetchMetrics() {
        LOG.debug("Start fetching metrics.");
        try {
            Optional<T> optionalLeaderGateway = this.retriever.getNow();
            if (optionalLeaderGateway.isPresent()) {
                RestfulGateway leaderGateway = (RestfulGateway)optionalLeaderGateway.get();
                CompletableFuture<MultipleJobsDetails> jobDetailsFuture = leaderGateway.requestJobDetails(true, true, this.timeout);
                jobDetailsFuture.whenCompleteAsync((jobDetails, throwable) -> {
                    if (throwable != null) {
                        LOG.debug("Fetching of JobDetails failed.", throwable);
                    } else {
                        ArrayList<String> activeJobs = new ArrayList<String>();
                        for (JobDetails job : jobDetails.getRunning()) {
                            activeJobs.add(job.getJobId().toString());
                        }
                        for (JobDetails job : jobDetails.getFinished()) {
                            activeJobs.add(job.getJobId().toString());
                        }
                        this.metrics.retainJobs(activeJobs);
                    }
                }, this.executor);
                CompletableFuture<Collection<String>> queryServicePathsFuture = leaderGateway.requestMetricQueryServicePaths(this.timeout);
                queryServicePathsFuture.whenCompleteAsync((queryServicePaths, throwable) -> {
                    if (throwable != null) {
                        LOG.warn("Requesting paths for query services failed.", throwable);
                    } else {
                        for (String queryServicePath : queryServicePaths) {
                            this.retrieveAndQueryMetrics(queryServicePath);
                        }
                    }
                }, this.executor);
                CompletableFuture<Collection<Tuple2<ResourceID, String>>> taskManagerQueryServicePathsFuture = leaderGateway.requestTaskManagerMetricQueryServicePaths(this.timeout);
                taskManagerQueryServicePathsFuture.whenCompleteAsync((queryServicePaths, throwable) -> {
                    if (throwable != null) {
                        LOG.warn("Requesting TaskManager's path for query services failed.", throwable);
                    } else {
                        List<String> taskManagersToRetain = queryServicePaths.stream().map(tuple -> {
                            this.retrieveAndQueryMetrics((String)tuple.f1);
                            return ((ResourceID)tuple.f0).getResourceIdString();
                        }).collect(Collectors.toList());
                        this.metrics.retainTaskManagers(taskManagersToRetain);
                    }
                }, this.executor);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception while fetching metrics.", (Throwable)e);
        }
    }

    private void retrieveAndQueryMetrics(String queryServicePath) {
        LOG.debug("Retrieve metric query service gateway for {}", (Object)queryServicePath);
        CompletableFuture<MetricQueryServiceGateway> queryServiceGatewayFuture = this.queryServiceRetriever.retrieveService(queryServicePath);
        queryServiceGatewayFuture.whenCompleteAsync((queryServiceGateway, t) -> {
            if (t != null) {
                LOG.debug("Could not retrieve QueryServiceGateway.", t);
            } else {
                this.queryMetrics((MetricQueryServiceGateway)queryServiceGateway);
            }
        }, this.executor);
    }

    private void queryMetrics(MetricQueryServiceGateway queryServiceGateway) {
        LOG.debug("Query metrics for {}.", (Object)queryServiceGateway.getAddress());
        queryServiceGateway.queryMetrics(this.timeout).whenCompleteAsync((result, t) -> {
            if (t != null) {
                LOG.debug("Fetching metrics failed.", t);
            } else {
                this.metrics.addAll(this.deserializer.deserialize((MetricDumpSerialization.MetricSerializationResult)result));
            }
        }, this.executor);
    }
}

