/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.metrics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.rest.handler.legacy.metrics.AbstractAggregatingMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;

public class AggregatingTaskManagersMetricsHandler
extends AbstractAggregatingMetricsHandler {
    public AggregatingTaskManagersMetricsHandler(Executor executor, MetricFetcher fetcher) {
        super(executor, fetcher);
    }

    @Override
    protected Collection<? extends MetricStore.ComponentMetricStore> getStores(MetricStore store, Map<String, String> pathParameters, Map<String, String> queryParameters) {
        String taskmanagersList = queryParameters.get("taskmanagers");
        if (taskmanagersList == null || taskmanagersList.isEmpty()) {
            return store.getTaskManagers().values();
        }
        String[] taskmanagers = taskmanagersList.split(",");
        ArrayList<MetricStore.TaskManagerMetricStore> taskmanagerStores = new ArrayList<MetricStore.TaskManagerMetricStore>();
        for (String taskmanager : taskmanagers) {
            taskmanagerStores.add(store.getTaskManagerMetricStore(taskmanager));
        }
        return taskmanagerStores;
    }

    @Override
    public String[] getPaths() {
        return new String[]{"/taskmanagers/metrics"};
    }
}

