/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.checkpoints;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.jobgraph.tasks.ExternalizedCheckpointSettings;
import org.apache.flink.runtime.rest.handler.legacy.AbstractExecutionGraphRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JsonFactory;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.util.FlinkException;

public class CheckpointConfigHandler
extends AbstractExecutionGraphRequestHandler {
    private static final String CHECKPOINT_CONFIG_REST_PATH = "/jobs/:jobid/checkpoints/config";

    public CheckpointConfigHandler(ExecutionGraphCache executionGraphHolder, Executor executor) {
        super(executionGraphHolder, executor);
    }

    @Override
    public String[] getPaths() {
        return new String[]{CHECKPOINT_CONFIG_REST_PATH};
    }

    @Override
    public CompletableFuture<String> handleRequest(AccessExecutionGraph graph, Map<String, String> params) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return CheckpointConfigHandler.createCheckpointConfigJson(graph);
            }
            catch (IOException e) {
                throw new CompletionException(new FlinkException("Could not create checkpoint config json.", (Throwable)e));
            }
        }, this.executor);
    }

    private static String createCheckpointConfigJson(AccessExecutionGraph graph) throws IOException {
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
        CheckpointCoordinatorConfiguration jobCheckpointingConfiguration = graph.getCheckpointCoordinatorConfiguration();
        if (jobCheckpointingConfiguration == null) {
            return "{}";
        }
        gen.writeStartObject();
        gen.writeStringField("mode", jobCheckpointingConfiguration.isExactlyOnce() ? "exactly_once" : "at_least_once");
        gen.writeNumberField("interval", jobCheckpointingConfiguration.getCheckpointInterval());
        gen.writeNumberField("timeout", jobCheckpointingConfiguration.getCheckpointTimeout());
        gen.writeNumberField("min_pause", jobCheckpointingConfiguration.getMinPauseBetweenCheckpoints());
        gen.writeNumberField("max_concurrent", jobCheckpointingConfiguration.getMaxConcurrentCheckpoints());
        ExternalizedCheckpointSettings externalization = jobCheckpointingConfiguration.getExternalizedCheckpointSettings();
        gen.writeObjectFieldStart("externalization");
        if (externalization.externalizeCheckpoints()) {
            gen.writeBooleanField("enabled", true);
            gen.writeBooleanField("delete_on_cancellation", externalization.deleteOnCancellation());
        } else {
            gen.writeBooleanField("enabled", false);
        }
        gen.writeEndObject();
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }

    public static class CheckpointConfigJsonArchivist
    implements JsonArchivist {
        @Override
        public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
            String json = CheckpointConfigHandler.createCheckpointConfigJson(graph);
            String path = CheckpointConfigHandler.CHECKPOINT_CONFIG_REST_PATH.replace(":jobid", graph.getJobID().toString());
            return Collections.singletonList(new ArchivedJson(path, json));
        }
    }
}

