/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.rest.handler.legacy.AbstractJsonRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.JsonFactory;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.util.FlinkException;

public class TaskManagersHandler
extends AbstractJsonRequestHandler {
    private static final String TASKMANAGERS_REST_PATH = "/taskmanagers";
    private static final String TASKMANAGER_DETAILS_REST_PATH = "/taskmanagers/:taskmanagerid";
    public static final String TASK_MANAGER_ID_KEY = "taskmanagerid";
    private final Time timeout;
    private final MetricFetcher fetcher;

    public TaskManagersHandler(Executor executor, Time timeout, MetricFetcher fetcher) {
        super(executor);
        this.timeout = Objects.requireNonNull(timeout);
        this.fetcher = fetcher;
    }

    @Override
    public String[] getPaths() {
        return new String[]{TASKMANAGERS_REST_PATH, TASKMANAGER_DETAILS_REST_PATH};
    }

    @Override
    public CompletableFuture<String> handleJsonRequest(Map<String, String> pathParams, Map<String, String> queryParams, JobManagerGateway jobManagerGateway) {
        if (jobManagerGateway != null) {
            if (pathParams.containsKey(TASK_MANAGER_ID_KEY)) {
                String unescapedString;
                try {
                    unescapedString = URLDecoder.decode(pathParams.get(TASK_MANAGER_ID_KEY), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    return FutureUtils.completedExceptionally(new FlinkException("Could not decode task manager id: " + pathParams.get(TASK_MANAGER_ID_KEY) + '.', (Throwable)e));
                }
                ResourceID resourceId = new ResourceID(unescapedString);
                CompletableFuture<Optional<Instance>> tmInstanceFuture = jobManagerGateway.requestTaskManagerInstance(resourceId, this.timeout);
                return tmInstanceFuture.thenApplyAsync(optTaskManager -> {
                    try {
                        return this.writeTaskManagersJson(optTaskManager.map(Collections::singleton).orElse(Collections.emptySet()), pathParams);
                    }
                    catch (IOException e) {
                        throw new CompletionException(new FlinkException("Could not write TaskManagers JSON.", (Throwable)e));
                    }
                }, this.executor);
            }
            CompletableFuture<Collection<Instance>> tmInstancesFuture = jobManagerGateway.requestTaskManagerInstances(this.timeout);
            return tmInstancesFuture.thenApplyAsync(taskManagers -> {
                try {
                    return this.writeTaskManagersJson((Collection<Instance>)taskManagers, pathParams);
                }
                catch (IOException e) {
                    throw new CompletionException(new FlinkException("Could not write TaskManagers JSON.", (Throwable)e));
                }
            }, this.executor);
        }
        return FutureUtils.completedExceptionally(new Exception("No connection to the leading JobManager."));
    }

    private String writeTaskManagersJson(Collection<Instance> instances, Map<String, String> pathParams) throws IOException {
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
        gen.writeStartObject();
        gen.writeArrayFieldStart("taskmanagers");
        for (Instance instance : instances) {
            gen.writeStartObject();
            gen.writeStringField("id", instance.getTaskManagerID().getResourceIdString());
            gen.writeStringField("path", instance.getTaskManagerGateway().getAddress());
            gen.writeNumberField("dataPort", instance.getTaskManagerLocation().dataPort());
            gen.writeNumberField("timeSinceLastHeartbeat", instance.getLastHeartBeat());
            gen.writeNumberField("slotsNumber", instance.getTotalNumberOfSlots());
            gen.writeNumberField("freeSlots", instance.getNumberOfAvailableSlots());
            gen.writeNumberField("cpuCores", instance.getResources().getNumberOfCPUCores());
            gen.writeNumberField("physicalMemory", instance.getResources().getSizeOfPhysicalMemory());
            gen.writeNumberField("freeMemory", instance.getResources().getSizeOfJvmHeap());
            gen.writeNumberField("managedMemory", instance.getResources().getSizeOfManagedMemory());
            if (pathParams.containsKey(TASK_MANAGER_ID_KEY)) {
                this.fetcher.update();
                MetricStore.TaskManagerMetricStore metrics = this.fetcher.getMetricStore().getTaskManagerMetricStore(instance.getTaskManagerID().getResourceIdString());
                if (metrics != null) {
                    gen.writeObjectFieldStart("metrics");
                    long heapUsed = Long.valueOf(metrics.getMetric("Status.JVM.Memory.Heap.Used", "0"));
                    long heapCommitted = Long.valueOf(metrics.getMetric("Status.JVM.Memory.Heap.Committed", "0"));
                    long heapTotal = Long.valueOf(metrics.getMetric("Status.JVM.Memory.Heap.Max", "0"));
                    gen.writeNumberField("heapCommitted", heapCommitted);
                    gen.writeNumberField("heapUsed", heapUsed);
                    gen.writeNumberField("heapMax", heapTotal);
                    long nonHeapUsed = Long.valueOf(metrics.getMetric("Status.JVM.Memory.NonHeap.Used", "0"));
                    long nonHeapCommitted = Long.valueOf(metrics.getMetric("Status.JVM.Memory.NonHeap.Committed", "0"));
                    long nonHeapTotal = Long.valueOf(metrics.getMetric("Status.JVM.Memory.NonHeap.Max", "0"));
                    gen.writeNumberField("nonHeapCommitted", nonHeapCommitted);
                    gen.writeNumberField("nonHeapUsed", nonHeapUsed);
                    gen.writeNumberField("nonHeapMax", nonHeapTotal);
                    gen.writeNumberField("totalCommitted", heapCommitted + nonHeapCommitted);
                    gen.writeNumberField("totalUsed", heapUsed + nonHeapUsed);
                    gen.writeNumberField("totalMax", heapTotal + nonHeapTotal);
                    long directCount = Long.valueOf(metrics.getMetric("Status.JVM.Memory.Direct.Count", "0"));
                    long directUsed = Long.valueOf(metrics.getMetric("Status.JVM.Memory.Direct.MemoryUsed", "0"));
                    long directMax = Long.valueOf(metrics.getMetric("Status.JVM.Memory.Direct.TotalCapacity", "0"));
                    gen.writeNumberField("directCount", directCount);
                    gen.writeNumberField("directUsed", directUsed);
                    gen.writeNumberField("directMax", directMax);
                    long mappedCount = Long.valueOf(metrics.getMetric("Status.JVM.Memory.Mapped.Count", "0"));
                    long mappedUsed = Long.valueOf(metrics.getMetric("Status.JVM.Memory.Mapped.MemoryUsed", "0"));
                    long mappedMax = Long.valueOf(metrics.getMetric("Status.JVM.Memory.Mapped.TotalCapacity", "0"));
                    gen.writeNumberField("mappedCount", mappedCount);
                    gen.writeNumberField("mappedUsed", mappedUsed);
                    gen.writeNumberField("mappedMax", mappedMax);
                    long memorySegmentsAvailable = Long.valueOf(metrics.getMetric("Status.Network.AvailableMemorySegments", "0"));
                    long memorySegmentsTotal = Long.valueOf(metrics.getMetric("Status.Network.TotalMemorySegments", "0"));
                    gen.writeNumberField("memorySegmentsAvailable", memorySegmentsAvailable);
                    gen.writeNumberField("memorySegmentsTotal", memorySegmentsTotal);
                    gen.writeArrayFieldStart("garbageCollectors");
                    for (String gcName : metrics.garbageCollectorNames) {
                        String count = metrics.getMetric("Status.JVM.GarbageCollector." + gcName + ".Count", null);
                        String time = metrics.getMetric("Status.JVM.GarbageCollector." + gcName + ".Time", null);
                        if (count == null || time == null) continue;
                        gen.writeStartObject();
                        gen.writeStringField("name", gcName);
                        gen.writeNumberField("count", Long.valueOf(count).longValue());
                        gen.writeNumberField("time", Long.valueOf(time).longValue());
                        gen.writeEndObject();
                    }
                    gen.writeEndArray();
                    gen.writeEndObject();
                }
            }
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }
}

