/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.rest.handler.legacy.AbstractJobVertexRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JsonFactory;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.util.MutableIOMetrics;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.util.FlinkException;

public class JobVertexDetailsHandler
extends AbstractJobVertexRequestHandler {
    private static final String JOB_VERTEX_DETAILS_REST_PATH = "/jobs/:jobid/vertices/:vertexid";
    private final MetricFetcher fetcher;

    public JobVertexDetailsHandler(ExecutionGraphCache executionGraphHolder, Executor executor, MetricFetcher fetcher) {
        super(executionGraphHolder, executor);
        this.fetcher = fetcher;
    }

    @Override
    public String[] getPaths() {
        return new String[]{JOB_VERTEX_DETAILS_REST_PATH};
    }

    @Override
    public CompletableFuture<String> handleRequest(AccessExecutionJobVertex jobVertex, Map<String, String> params) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return JobVertexDetailsHandler.createVertexDetailsJson(jobVertex, (String)params.get("jobid"), this.fetcher);
            }
            catch (IOException e) {
                throw new CompletionException(new FlinkException("Could not write the vertex details json.", (Throwable)e));
            }
        }, this.executor);
    }

    public static String createVertexDetailsJson(AccessExecutionJobVertex jobVertex, String jobID, @Nullable MetricFetcher fetcher) throws IOException {
        long now = System.currentTimeMillis();
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
        gen.writeStartObject();
        gen.writeStringField("id", jobVertex.getJobVertexId().toString());
        gen.writeStringField("name", jobVertex.getName());
        gen.writeNumberField("parallelism", jobVertex.getParallelism());
        gen.writeNumberField("now", now);
        gen.writeArrayFieldStart("subtasks");
        int num = 0;
        for (AccessExecutionVertex vertex : jobVertex.getTaskVertices()) {
            long endTime;
            ExecutionState status = vertex.getExecutionState();
            TaskManagerLocation location = vertex.getCurrentAssignedResourceLocation();
            String locationString = location == null ? "(unassigned)" : location.getHostname() + ":" + location.dataPort();
            long startTime = vertex.getStateTimestamp(ExecutionState.DEPLOYING);
            if (startTime == 0L) {
                startTime = -1L;
            }
            long l = endTime = status.isTerminal() ? vertex.getStateTimestamp(status) : -1L;
            long duration = startTime > 0L ? (endTime > 0L ? endTime : now) - startTime : -1L;
            gen.writeStartObject();
            gen.writeNumberField("subtask", num);
            gen.writeStringField("status", status.name());
            gen.writeNumberField("attempt", vertex.getCurrentExecutionAttempt().getAttemptNumber());
            gen.writeStringField("host", locationString);
            gen.writeNumberField("start-time", startTime);
            gen.writeNumberField("end-time", endTime);
            gen.writeNumberField("duration", duration);
            MutableIOMetrics counts = new MutableIOMetrics();
            counts.addIOMetrics(vertex.getCurrentExecutionAttempt(), fetcher, jobID, jobVertex.getJobVertexId().toString());
            counts.writeIOMetricsAsJson(gen);
            gen.writeEndObject();
            ++num;
        }
        gen.writeEndArray();
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }

    public static class JobVertexDetailsJsonArchivist
    implements JsonArchivist {
        @Override
        public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
            ArrayList<ArchivedJson> archive = new ArrayList<ArchivedJson>();
            for (AccessExecutionJobVertex accessExecutionJobVertex : graph.getAllVertices().values()) {
                String json = JobVertexDetailsHandler.createVertexDetailsJson(accessExecutionJobVertex, graph.getJobID().toString(), null);
                String path = JobVertexDetailsHandler.JOB_VERTEX_DETAILS_REST_PATH.replace(":jobid", graph.getJobID().toString()).replace(":vertexid", accessExecutionJobVertex.getJobVertexId().toString());
                archive.add(new ArchivedJson(path, json));
            }
            return archive;
        }
    }
}

