/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.rest.handler.legacy.AbstractExecutionGraphRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JsonFactory;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.util.FlinkException;

public class JobExceptionsHandler
extends AbstractExecutionGraphRequestHandler {
    private static final String JOB_EXCEPTIONS_REST_PATH = "/jobs/:jobid/exceptions";
    static final int MAX_NUMBER_EXCEPTION_TO_REPORT = 20;

    public JobExceptionsHandler(ExecutionGraphCache executionGraphHolder, Executor executor) {
        super(executionGraphHolder, executor);
    }

    @Override
    public String[] getPaths() {
        return new String[]{JOB_EXCEPTIONS_REST_PATH};
    }

    @Override
    public CompletableFuture<String> handleRequest(AccessExecutionGraph graph, Map<String, String> params) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return JobExceptionsHandler.createJobExceptionsJson(graph);
            }
            catch (IOException e) {
                throw new CompletionException(new FlinkException("Could not create job exceptions json.", (Throwable)e));
            }
        }, this.executor);
    }

    public static String createJobExceptionsJson(AccessExecutionGraph graph) throws IOException {
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
        gen.writeStartObject();
        ErrorInfo rootException = graph.getFailureCause();
        if (rootException != null && !rootException.getExceptionAsString().equals("(null)")) {
            gen.writeStringField("root-exception", rootException.getExceptionAsString());
            gen.writeNumberField("timestamp", rootException.getTimestamp());
        }
        gen.writeArrayFieldStart("all-exceptions");
        int numExceptionsSoFar = 0;
        boolean truncated = false;
        for (AccessExecutionVertex accessExecutionVertex : graph.getAllExecutionVertices()) {
            String t = accessExecutionVertex.getFailureCauseAsString();
            if (t == null || t.equals("(null)")) continue;
            if (numExceptionsSoFar >= 20) {
                truncated = true;
                break;
            }
            TaskManagerLocation location = accessExecutionVertex.getCurrentAssignedResourceLocation();
            String locationString = location != null ? location.getFQDNHostname() + ':' + location.dataPort() : "(unassigned)";
            gen.writeStartObject();
            gen.writeStringField("exception", t);
            gen.writeStringField("task", accessExecutionVertex.getTaskNameWithSubtaskIndex());
            gen.writeStringField("location", locationString);
            long timestamp = accessExecutionVertex.getStateTimestamp(ExecutionState.FAILED);
            gen.writeNumberField("timestamp", timestamp == 0L ? -1L : timestamp);
            gen.writeEndObject();
            ++numExceptionsSoFar;
        }
        gen.writeEndArray();
        gen.writeBooleanField("truncated", truncated);
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }

    public static class JobExceptionsJsonArchivist
    implements JsonArchivist {
        @Override
        public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
            String json = JobExceptionsHandler.createJobExceptionsJson(graph);
            String path = JobExceptionsHandler.JOB_EXCEPTIONS_REST_PATH.replace(":jobid", graph.getJobID().toString());
            return Collections.singletonList(new ArchivedJson(path, json));
        }
    }
}

