/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.rest.handler.legacy.AbstractExecutionGraphRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JsonFactory;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.util.FlinkException;

public class JobAccumulatorsHandler
extends AbstractExecutionGraphRequestHandler {
    private static final String JOB_ACCUMULATORS_REST_PATH = "/jobs/:jobid/accumulators";

    public JobAccumulatorsHandler(ExecutionGraphCache executionGraphHolder, Executor executor) {
        super(executionGraphHolder, executor);
    }

    @Override
    public String[] getPaths() {
        return new String[]{JOB_ACCUMULATORS_REST_PATH};
    }

    @Override
    public CompletableFuture<String> handleRequest(AccessExecutionGraph graph, Map<String, String> params) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return JobAccumulatorsHandler.createJobAccumulatorsJson(graph);
            }
            catch (IOException e) {
                throw new CompletionException(new FlinkException("Could not create job accumulators json.", (Throwable)e));
            }
        }, this.executor);
    }

    public static String createJobAccumulatorsJson(AccessExecutionGraph graph) throws IOException {
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
        StringifiedAccumulatorResult[] allAccumulators = graph.getAccumulatorResultsStringified();
        gen.writeStartObject();
        gen.writeArrayFieldStart("job-accumulators");
        gen.writeEndArray();
        gen.writeArrayFieldStart("user-task-accumulators");
        for (StringifiedAccumulatorResult acc : allAccumulators) {
            gen.writeStartObject();
            gen.writeStringField("name", acc.getName());
            gen.writeStringField("type", acc.getType());
            gen.writeStringField("value", acc.getValue());
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }

    public static class JobAccumulatorsJsonArchivist
    implements JsonArchivist {
        @Override
        public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
            String json = JobAccumulatorsHandler.createJobAccumulatorsJson(graph);
            String path = JobAccumulatorsHandler.JOB_ACCUMULATORS_REST_PATH.replace(":jobid", graph.getJobID().toString());
            return Collections.singletonList(new ArchivedJson(path, json));
        }
    }
}

