/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.messages.webmonitor.JobsWithIDsOverview;
import org.apache.flink.runtime.rest.handler.legacy.AbstractJsonRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.JsonFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.util.FlinkException;

public class CurrentJobIdsHandler
extends AbstractJsonRequestHandler {
    private static final String CURRENT_JOB_IDS_REST_PATH = "/jobs";
    private final Time timeout;

    public CurrentJobIdsHandler(Executor executor, Time timeout) {
        super(executor);
        this.timeout = Objects.requireNonNull(timeout);
    }

    @Override
    public String[] getPaths() {
        return new String[]{CURRENT_JOB_IDS_REST_PATH};
    }

    @Override
    public CompletableFuture<String> handleJsonRequest(Map<String, String> pathParams, Map<String, String> queryParams, JobManagerGateway jobManagerGateway) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (jobManagerGateway != null) {
                    CompletableFuture<JobsWithIDsOverview> overviewFuture = jobManagerGateway.requestJobsOverview(this.timeout);
                    JobsWithIDsOverview overview = overviewFuture.get(this.timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
                    StringWriter writer = new StringWriter();
                    JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
                    gen.writeStartObject();
                    gen.writeArrayFieldStart("jobs-running");
                    for (JobID jid : overview.getJobsRunningOrPending()) {
                        gen.writeString(jid.toString());
                    }
                    gen.writeEndArray();
                    gen.writeArrayFieldStart("jobs-finished");
                    for (JobID jid : overview.getJobsFinished()) {
                        gen.writeString(jid.toString());
                    }
                    gen.writeEndArray();
                    gen.writeArrayFieldStart("jobs-cancelled");
                    for (JobID jid : overview.getJobsCancelled()) {
                        gen.writeString(jid.toString());
                    }
                    gen.writeEndArray();
                    gen.writeArrayFieldStart("jobs-failed");
                    for (JobID jid : overview.getJobsFailed()) {
                        gen.writeString(jid.toString());
                    }
                    gen.writeEndArray();
                    gen.writeEndObject();
                    gen.close();
                    return writer.toString();
                }
                throw new Exception("No connection to the leading JobManager.");
            }
            catch (Exception e) {
                throw new CompletionException(new FlinkException("Failed to fetch list of all running jobs.", (Throwable)e));
            }
        }, this.executor);
    }
}

