/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.AbstractExecutionGraphHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobExceptionsInfo;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JobExceptionsHandler
extends AbstractExecutionGraphHandler<JobExceptionsInfo, JobMessageParameters> {
    static final int MAX_NUMBER_EXCEPTION_TO_REPORT = 20;

    public JobExceptionsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, MessageHeaders<EmptyRequestBody, JobExceptionsInfo, JobMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor) {
        super(localRestAddress, leaderRetriever, timeout, messageHeaders, executionGraphCache, executor);
    }

    @Override
    protected JobExceptionsInfo handleRequest(HandlerRequest<EmptyRequestBody, JobMessageParameters> request, AccessExecutionGraph executionGraph) {
        ErrorInfo rootException = executionGraph.getFailureCause();
        String rootExceptionMessage = null;
        Long rootTimestamp = null;
        if (rootException != null && !rootException.getExceptionAsString().equals("(null)")) {
            rootExceptionMessage = rootException.getExceptionAsString();
            rootTimestamp = rootException.getTimestamp();
        }
        ArrayList<JobExceptionsInfo.ExecutionExceptionInfo> taskExceptionList = new ArrayList<JobExceptionsInfo.ExecutionExceptionInfo>();
        boolean truncated = false;
        for (AccessExecutionVertex accessExecutionVertex : executionGraph.getAllExecutionVertices()) {
            String t = accessExecutionVertex.getFailureCauseAsString();
            if (t == null || t.equals("(null)")) continue;
            if (taskExceptionList.size() >= 20) {
                truncated = true;
                break;
            }
            TaskManagerLocation location = accessExecutionVertex.getCurrentAssignedResourceLocation();
            String locationString = location != null ? location.getFQDNHostname() + ':' + location.dataPort() : "(unassigned)";
            long timestamp = accessExecutionVertex.getStateTimestamp(ExecutionState.FAILED);
            taskExceptionList.add(new JobExceptionsInfo.ExecutionExceptionInfo(t, accessExecutionVertex.getTaskNameWithSubtaskIndex(), locationString, timestamp == 0L ? -1L : timestamp));
        }
        return new JobExceptionsInfo(rootExceptionMessage, rootTimestamp, taskExceptionList, truncated);
    }
}

