/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.ArchivedExecutionConfig;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.AbstractExecutionGraphHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobConfigInfo;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JobConfigHandler
extends AbstractExecutionGraphHandler<JobConfigInfo, JobMessageParameters> {
    public JobConfigHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, MessageHeaders<EmptyRequestBody, JobConfigInfo, JobMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor) {
        super(localRestAddress, leaderRetriever, timeout, messageHeaders, executionGraphCache, executor);
    }

    @Override
    protected JobConfigInfo handleRequest(HandlerRequest<EmptyRequestBody, JobMessageParameters> request, AccessExecutionGraph executionGraph) {
        ArchivedExecutionConfig executionConfig = executionGraph.getArchivedExecutionConfig();
        JobConfigInfo.ExecutionConfigInfo executionConfigInfo = executionConfig != null ? new JobConfigInfo.ExecutionConfigInfo(executionConfig.getExecutionMode(), executionConfig.getRestartStrategyDescription(), executionConfig.getParallelism(), executionConfig.getObjectReuseEnabled(), executionConfig.getGlobalJobParameters()) : null;
        return new JobConfigInfo(executionGraph.getJobID(), executionGraph.getJobName(), executionConfigInfo);
    }
}

